/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.component;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.primefaces.selenium.PrimeExpectedConditions;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.base.AbstractComponent;
import org.primefaces.selenium.component.base.ComponentUtils;
import org.primefaces.selenium.findby.FindByParentPartialId;

public abstract class PickList
extends AbstractComponent {
    private static final String ITEM_LABEL_ATTR = "data-item-label";
    private static final String ITEM_VALUE_ATTR = "data-item-value";
    private static final By CHECK_SELECTOR = By.cssSelector((String)"div[class*='ui-chkbox']");
    @FindBy(css="button[class*='ui-picklist-button-add']")
    private WebElement add;
    @FindBy(css="button[class*='ui-picklist-button-add-all']")
    private WebElement addAll;
    @FindBy(css="button[class*='ui-picklist-button-remove']")
    private WebElement remove;
    @FindBy(css="button[class*='ui-picklist-button-remove-all']")
    private WebElement removeAll;
    @FindBy(css="ul[class*='ui-picklist-source']")
    private WebElement sourceList;
    @FindBy(css="ul[class*='ui-picklist-target']")
    private WebElement targetList;
    @FindByParentPartialId(value="_source_filter")
    private WebElement sourceFilter;
    @FindByParentPartialId(value="_target_filter")
    private WebElement targetFilter;

    public void pick(String ... items) {
        this.selectAndAction(this.sourceList, this.add, items);
    }

    public void pickAll() {
        this.addAll.click();
    }

    public void remove(String ... items) {
        this.selectAndAction(this.targetList, this.remove, items);
    }

    public void removeAll() {
        this.removeAll.click();
    }

    public void moveSourceItemsUp(String ... items) {
        WebElement moveUp = this.getMoveUpButton(this.getSourceControls());
        this.selectAndAction(this.sourceList, moveUp, items);
    }

    public void moveSourceItemsDown(String ... items) {
        WebElement moveDown = this.getMoveDownButton(this.getSourceControls());
        this.selectAndAction(this.sourceList, moveDown, items);
    }

    public void moveSourceItemsToTop(String ... items) {
        WebElement moveTop = this.getMoveTopButton(this.getSourceControls());
        this.selectAndAction(this.sourceList, moveTop, items);
    }

    public void moveSourceItemsToBottom(String ... items) {
        WebElement moveBottom = this.getMoveBottomButton(this.getSourceControls());
        this.selectAndAction(this.sourceList, moveBottom, items);
    }

    public void moveTargetItemsUp(String ... items) {
        WebElement moveUp = this.getMoveUpButton(this.getTargetControls());
        this.selectAndAction(this.targetList, moveUp, items);
    }

    public void moveTargetItemsDown(String ... items) {
        WebElement moveDown = this.getMoveDownButton(this.getTargetControls());
        this.selectAndAction(this.targetList, moveDown, items);
    }

    public void moveTargetItemsToTop(String ... items) {
        WebElement moveTop = this.getMoveTopButton(this.getTargetControls());
        this.selectAndAction(this.targetList, moveTop, items);
    }

    public void moveTargetItemsToBottom(String ... items) {
        WebElement moveBottom = this.getMoveBottomButton(this.getTargetControls());
        this.selectAndAction(this.targetList, moveBottom, items);
    }

    public void filterSourceList(String filterValue) {
        this.setFilterValue(this.sourceFilter, filterValue);
    }

    public void filterTargetList(String filterValue) {
        this.setFilterValue(this.targetFilter, filterValue);
    }

    public void clearSourceListFilter() {
        this.setFilterValue(this.sourceFilter, "");
    }

    public void clearTargetListFilter() {
        this.setFilterValue(this.targetFilter, "");
    }

    public void setFilterValue(WebElement filterElement, String filterValue) {
        JSONObject cfg = this.getWidgetConfiguration();
        String filterEvent = cfg.getString("filterEvent");
        int filterDelay = cfg.getInt("filterDelay");
        this.setFilterValue(filterElement, filterValue, filterEvent, filterDelay);
    }

    public void setFilterValue(WebElement filterElement, String filterValue, String filterEvent, int filterDelay) {
        PrimeSelenium.clearInput((WebElement)filterElement, (boolean)false);
        Keys triggerKey = null;
        switch (filterEvent = filterEvent.toLowerCase(Locale.ROOT)) {
            case "keyup": 
            case "keydown": 
            case "keypress": 
            case "input": {
                if (filterDelay != 0) break;
                filterElement = (WebElement)PrimeSelenium.guardAjax((Object)filterElement);
                break;
            }
            case "enter": {
                triggerKey = Keys.ENTER;
                break;
            }
            case "change": 
            case "blur": {
                triggerKey = Keys.TAB;
                break;
            }
        }
        if (filterValue != null) {
            ComponentUtils.sendKeys(filterElement, filterValue);
        } else {
            filterElement.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
        }
        if (triggerKey != null) {
            filterElement.sendKeys(new CharSequence[]{triggerKey});
        } else if (filterDelay > 0) {
            PrimeSelenium.wait((int)(filterDelay + 10));
            PrimeSelenium.waitGui().until((Function)PrimeExpectedConditions.animationNotActive());
        }
    }

    public List<String> getSourceListValues() {
        return this.getSourceListElements().stream().map(e -> e.getAttribute(ITEM_VALUE_ATTR)).collect(Collectors.toList());
    }

    public List<String> getSourceListLabels() {
        return this.getSourceListElements().stream().map(e -> e.getAttribute(ITEM_LABEL_ATTR)).collect(Collectors.toList());
    }

    public List<WebElement> getSourceListElements() {
        return this.sourceList.findElements(By.tagName((String)"li")).stream().filter(e -> PrimeSelenium.isElementDisplayed((WebElement)e)).collect(Collectors.toList());
    }

    public List<String> getTargetListValues() {
        return this.getTargetListElements().stream().map(e -> e.getAttribute(ITEM_VALUE_ATTR)).collect(Collectors.toList());
    }

    public List<String> getTargetListLabels() {
        return this.getTargetListElements().stream().map(e -> e.getAttribute(ITEM_LABEL_ATTR)).collect(Collectors.toList());
    }

    public List<WebElement> getTargetListElements() {
        return this.targetList.findElements(By.tagName((String)"li")).stream().filter(e -> PrimeSelenium.isElementDisplayed((WebElement)e)).collect(Collectors.toList());
    }

    public boolean isCheckboxSelectionEnabled() {
        List<WebElement> sourceElements = this.getSourceListElements();
        if (!sourceElements.isEmpty()) {
            return this.getCheckbox(sourceElements.get(0)) != null;
        }
        List<WebElement> targetElements = this.getTargetListElements();
        if (!targetElements.isEmpty()) {
            return this.getCheckbox(targetElements.get(0)) != null;
        }
        return false;
    }

    private WebElement getSourceControls() {
        return this.findElement(By.cssSelector((String)"div[class*='ui-picklist-source-controls']"));
    }

    private WebElement getTargetControls() {
        return this.findElement(By.cssSelector((String)"div[class*='ui-picklist-target-controls']"));
    }

    private WebElement getMoveUpButton(WebElement controls) {
        return controls.findElement(By.cssSelector((String)"button[title='Move up']"));
    }

    private WebElement getMoveDownButton(WebElement controls) {
        return controls.findElement(By.cssSelector((String)"button[title='Move down']"));
    }

    private WebElement getMoveTopButton(WebElement controls) {
        return controls.findElement(By.cssSelector((String)"button[title='Move top']"));
    }

    private WebElement getMoveBottomButton(WebElement controls) {
        return controls.findElement(By.cssSelector((String)"button[title='Move bottom']"));
    }

    private void selectAndAction(WebElement list, WebElement actionButton, String ... items) {
        boolean hasCheckboxes = this.isCheckboxSelectionEnabled();
        for (String item : items) {
            WebElement element = this.findListItem(list, item);
            if (hasCheckboxes) {
                WebElement checkbox = this.getCheckbox(element);
                checkbox.click();
                continue;
            }
            element.click();
            actionButton.click();
        }
        if (hasCheckboxes && PrimeSelenium.isElementEnabled((WebElement)actionButton)) {
            actionButton.click();
        }
    }

    private WebElement findListItem(WebElement listElement, String item) {
        Optional<WebElement> listItem = listElement.findElements(By.tagName((String)"li")).stream().filter(e -> {
            String value = e.getAttribute(ITEM_VALUE_ATTR);
            String label = e.getAttribute(ITEM_LABEL_ATTR);
            return value.equals(item) || label.equals(item);
        }).findFirst();
        if (listItem.isPresent()) {
            return listItem.get();
        }
        throw new NoSuchElementException("Could not find element " + item + " in picklist " + this.getId());
    }

    private WebElement getCheckbox(WebElement element) {
        return element.findElements(CHECK_SELECTOR).stream().findFirst().orElse(null);
    }
}

