/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.component;

import java.util.function.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.primefaces.selenium.PrimeExpectedConditions;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.base.AbstractInputComponent;
import org.primefaces.selenium.component.base.ComponentUtils;

public abstract class ColorPicker
extends AbstractInputComponent {
    public WebElement getPanel() {
        return this.getWebDriver().findElement(By.id((String)"clr-picker"));
    }

    public WebElement getTriggerButton() {
        return this.findElement(By.xpath((String)"preceding-sibling::*"));
    }

    public boolean isOpenAjaxified() {
        return ComponentUtils.hasAjaxBehavior(this.getRoot(), "open");
    }

    public boolean isCloseAjaxified() {
        return ComponentUtils.hasAjaxBehavior(this.getRoot(), "close");
    }

    public void setColor(String color) {
        PrimeSelenium.executeScript((boolean)this.isOnchangeAjaxified(), (String)(this.getWidgetByIdScript() + ".setColor('" + color + "');"), (Object[])new Object[0]);
    }

    public String getColor() {
        return (String)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".getColor();"), (Object[])new Object[0]);
    }

    public WebElement showPanel() {
        if (this.isEnabled()) {
            if (!this.getPanel().isDisplayed()) {
                PrimeSelenium.executeScript((boolean)this.isOpenAjaxified(), (String)(this.getWidgetByIdScript() + ".show()"), (Object[])new Object[0]);
            }
            PrimeSelenium.waitGui().until((Function)PrimeExpectedConditions.visibleAndAnimationComplete((WebElement)this.getPanel()));
        }
        return this.getPanel();
    }

    public void hidePanel(boolean revert) {
        if (this.isEnabled()) {
            if (this.getPanel().isDisplayed()) {
                PrimeSelenium.executeScript((boolean)this.isCloseAjaxified(), (String)(this.getWidgetByIdScript() + ".hide(" + Boolean.toString(revert) + ");"), (Object[])new Object[0]);
            }
            PrimeSelenium.waitGui().until((Function)PrimeExpectedConditions.invisibleAndAnimationComplete((WebElement)this.getPanel()));
        }
    }
}

