/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.component.base;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.base.AbstractPageableData;
import org.primefaces.selenium.component.base.ComponentUtils;
import org.primefaces.selenium.component.model.datatable.Cell;
import org.primefaces.selenium.component.model.datatable.Header;
import org.primefaces.selenium.component.model.datatable.HeaderCell;
import org.primefaces.selenium.component.model.datatable.Row;

public abstract class AbstractTable<T extends Row>
extends AbstractPageableData {
    @Override
    public List<WebElement> getRowsWebElement() {
        return this.findElement(By.tagName((String)"table")).findElement(By.tagName((String)"tbody")).findElements(By.tagName((String)"tr"));
    }

    public abstract T getRow(int var1);

    public Cell getCell(int rowIndex, int colIndex) throws IndexOutOfBoundsException {
        T row = this.getRow(rowIndex);
        if (row == null) {
            throw new IndexOutOfBoundsException("Row " + rowIndex + " was not found in table");
        }
        Cell cell = ((Row)row).getCell(colIndex);
        if (cell == null) {
            throw new IndexOutOfBoundsException("Column " + colIndex + " was not found in Row " + rowIndex + ".");
        }
        return cell;
    }

    public WebElement getHeaderWebElement() {
        return this.findElement(By.tagName((String)"table")).findElement(By.tagName((String)"thead"));
    }

    public Header getHeader() {
        List<HeaderCell> cells = this.getHeaderWebElement().findElements(By.tagName((String)"th")).stream().map(HeaderCell::new).collect(Collectors.toList());
        return new Header(this.getHeaderWebElement(), cells);
    }

    public void sort(String headerText) {
        Optional<HeaderCell> cell = this.getHeader().getCell(headerText);
        if (cell.isPresent()) {
            ((WebElement)PrimeSelenium.guardAjax((Object)cell.get().getWebElement().findElement(By.className((String)"ui-sortable-column-icon")))).click();
        } else {
            System.err.println("Header Cell '" + headerText + "' not found.");
        }
    }

    public void sort(int index) {
        HeaderCell cell = this.getHeader().getCell(index);
        if (cell != null) {
            ((WebElement)PrimeSelenium.guardAjax((Object)cell.getWebElement().findElement(By.className((String)"ui-sortable-column-icon")))).click();
        } else {
            System.err.println("Header Cell '" + index + "' not found.");
        }
    }

    public void filter(int cellIndex, String filterValue) {
        this.filter(this.getHeader().getCell(cellIndex), filterValue);
    }

    public void filter(String headerText, String filterValue) {
        Optional<HeaderCell> cell = this.getHeader().getCell(headerText);
        if (cell.isPresent()) {
            this.filter(cell.get(), filterValue);
        } else {
            System.err.println("Header Cell '" + headerText + "' not found.");
        }
    }

    public void removeFilter(int cellIndex) {
        this.filter(cellIndex, null);
    }

    public void removeFilter(String headerText) {
        this.filter(headerText, null);
    }

    private void filter(HeaderCell cell, String filterValue) {
        JSONObject cfg = this.getWidgetConfiguration();
        if (filterValue != null && filterValue.isEmpty()) {
            filterValue = null;
        }
        cell.setFilterValue(cfg, filterValue);
    }

    public void toggleSelectAllCheckBox() {
        WebElement checkboxAll = this.getSelectAllCheckBox();
        if (ComponentUtils.hasBehavior((WebElement)this, "rowSelect") || ComponentUtils.hasBehavior((WebElement)this, "rowUnselect")) {
            ((WebElement)PrimeSelenium.guardAjax((Object)checkboxAll)).click();
        } else {
            checkboxAll.click();
        }
    }

    public WebElement getSelectAllCheckBox() {
        return this.getHeader().getCell(0).getWebElement();
    }
}

