/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.component.base;

import org.openqa.selenium.WebElement;
import org.primefaces.selenium.PrimeSelenium;

public final class ComponentUtils {
    private ComponentUtils() {
    }

    public static boolean hasAjaxBehavior(WebElement element, String behavior) {
        if (!ComponentUtils.hasBehavior(element, behavior)) {
            return false;
        }
        String id = element.getAttribute("id");
        String result = (String)PrimeSelenium.executeScript((String)("return " + ComponentUtils.getWidgetByIdScript(id) + ".getBehavior('" + behavior + "').toString();"), (Object[])new Object[0]);
        return ComponentUtils.isAjaxScript(result);
    }

    public static boolean hasBehavior(WebElement element, String behavior) {
        if (!ComponentUtils.isWidget(element)) {
            return false;
        }
        String id = element.getAttribute("id");
        return (Boolean)PrimeSelenium.executeScript((String)("return " + ComponentUtils.getWidgetByIdScript(id) + ".hasBehavior('" + behavior + "');"), (Object[])new Object[0]);
    }

    public static boolean isWidget(WebElement element) {
        String id = element.getAttribute("id");
        if (id == null || id.isEmpty()) {
            return false;
        }
        return (Boolean)PrimeSelenium.executeScript((String)("return " + ComponentUtils.getWidgetByIdScript(id) + " != null;"), (Object[])new Object[0]);
    }

    public static boolean isAjaxScript(String script) {
        if (script == null || script.isEmpty()) {
            return false;
        }
        return script.contains("PrimeFaces.ab(") || script.contains("pf.ab(") || script.contains("mojarra.ab(") || script.contains("jsf.ajax.request");
    }

    public static String getWidgetConfiguration(WebElement element) {
        String id = element.getAttribute("id");
        return (String)PrimeSelenium.executeScript((String)("return JSON.stringify(" + ComponentUtils.getWidgetByIdScript(id) + ".cfg, function(key, value) {\n  if (typeof value === 'function') {\n    return value.toString();\n  } else if (value && value.constructor && value.constructor.name === 'RegExp') {\n    return value.toString();\n  } else {\n    return value;\n  }\n});"), (Object[])new Object[0]);
    }

    public static String getWidgetByIdScript(String id) {
        return "PrimeFaces.getWidgetById('" + id + "')";
    }

    public static void sendKeys(WebElement input, CharSequence value) {
        if (input == null || value == null) {
            return;
        }
        if (PrimeSelenium.isChrome()) {
            input.click();
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                input.sendKeys(new CharSequence[]{Character.toString(c)});
            }
        } else {
            input.sendKeys(new CharSequence[]{value});
        }
    }
}

