/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.component;

import java.io.Serializable;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.primefaces.selenium.PrimeExpectedConditions;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.base.AbstractInputComponent;
import org.primefaces.selenium.component.base.ComponentUtils;
import org.primefaces.selenium.findby.FindByParentPartialId;

public abstract class AutoComplete
extends AbstractInputComponent {
    @FindByParentPartialId(value="_input")
    private WebElement input;
    @FindByParentPartialId(value="_panel", searchFromRoot=true)
    private WebElement panel;

    @Override
    public WebElement getInput() {
        return this.input;
    }

    public WebElement getItems() {
        return this.getWebDriver().findElement(By.className((String)"ui-autocomplete-items"));
    }

    public List<String> getItemValues() {
        List itemElements = this.getItems().findElements(By.className((String)"ui-autocomplete-item"));
        return itemElements.stream().map(WebElement::getText).collect(Collectors.toList());
    }

    public WebElement getPanel() {
        return this.panel;
    }

    public String getValue() {
        return this.getInput().getAttribute("value");
    }

    public boolean isClearAjaxified() {
        return ComponentUtils.hasAjaxBehavior(this.getRoot(), "clear");
    }

    public boolean isItemSelectAjaxified() {
        return ComponentUtils.hasAjaxBehavior(this.getRoot(), "itemSelect");
    }

    public boolean isItemUnselectAjaxified() {
        return ComponentUtils.hasAjaxBehavior(this.getRoot(), "itemUnselect");
    }

    public boolean isQueryAjaxified() {
        return ComponentUtils.hasAjaxBehavior(this.getRoot(), "query");
    }

    public List<String> getValues() {
        List<WebElement> tokens = this.getTokens();
        return tokens.stream().map(token -> token.findElement(By.className((String)"ui-autocomplete-token-label")).getText()).collect(Collectors.toList());
    }

    public List<WebElement> getTokens() {
        return this.findElements(By.cssSelector((String)"ul li.ui-autocomplete-token"));
    }

    public void setValue(String value) {
        int delay = this.setValueWithoutTab((Serializable)((Object)value));
        if (delay > 0) {
            PrimeSelenium.waitGui().until((Function)PrimeExpectedConditions.animationNotActive());
        }
        this.sendTabKey();
    }

    public int setValueWithoutTab(Serializable value) {
        WebElement input = this.getInput();
        input.clear();
        ComponentUtils.sendKeys(input, value.toString());
        int delay = this.getDelay();
        PrimeSelenium.wait((int)(delay * 2));
        return delay;
    }

    public void sendTabKey() {
        if (this.isOnchangeAjaxified()) {
            ((WebElement)PrimeSelenium.guardAjax((Object)this.getInput())).sendKeys(new CharSequence[]{Keys.TAB});
        } else {
            this.getInput().sendKeys(new CharSequence[]{Keys.TAB});
        }
    }

    @Override
    public void clear() {
        PrimeSelenium.clearInput((WebElement)this.getInput(), (boolean)this.isClearAjaxified());
    }

    public void wait4Panel() {
        PrimeSelenium.waitGui().until((Function)PrimeExpectedConditions.visibleAndAnimationComplete((WebElement)this.panel));
    }

    public void show() {
        WebElement panel = this.getPanel();
        if (this.isEnabled() && !panel.isDisplayed()) {
            PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".show();"), (Object[])new Object[0]);
            this.wait4Panel();
        }
    }

    public void hide() {
        WebElement panel = this.getPanel();
        if (this.isEnabled() && panel.isDisplayed()) {
            PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".hide();"), (Object[])new Object[0]);
            PrimeSelenium.waitGui().until((Function)PrimeExpectedConditions.invisibleAndAnimationComplete((WebElement)panel));
        }
    }

    public void activate() {
        PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".activate();"), (Object[])new Object[0]);
    }

    public void deactivate() {
        PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".deactivate();"), (Object[])new Object[0]);
    }

    public void addItem(String item) {
        PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".addItem('" + item + "');"), (Object[])new Object[0]);
    }

    public void removeItem(String item) {
        PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".removeItem('" + item + "');"), (Object[])new Object[0]);
    }

    public void search(String value) {
        PrimeSelenium.executeScript((boolean)true, (String)(this.getWidgetByIdScript() + ".search(arguments[0]);"), (Object[])new Object[]{value});
        this.wait4Panel();
    }

    public int getDelay() {
        return this.getWidgetConfiguration().getInt("delay");
    }
}

