/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.component;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.base.AbstractComponent;
import org.primefaces.selenium.component.base.ComponentUtils;
import org.primefaces.selenium.component.model.Tab;

public abstract class AccordionPanel
extends AbstractComponent {
    @FindBy(css=".ui-accordion-header")
    private List<WebElement> headers;
    @FindBy(css=".ui-accordion-content")
    private List<WebElement> contents;
    private List<Tab> tabs = null;

    public List<WebElement> getHeaders() {
        return this.headers;
    }

    public List<WebElement> getContents() {
        return this.contents;
    }

    public List<Tab> getTabs() {
        if (this.tabs == null) {
            ArrayList<Tab> tabs = new ArrayList<Tab>();
            AtomicInteger cnt = new AtomicInteger(0);
            this.headers.forEach(headerElt -> {
                String title = headerElt.getText();
                int index = cnt.getAndIncrement();
                WebElement content = this.getContents().get(index);
                tabs.add(new Tab(title, index, (WebElement)headerElt, content));
            });
            this.tabs = tabs;
        }
        return this.tabs;
    }

    public void toggleTab(int index) {
        if (ComponentUtils.hasAjaxBehavior(this.getRoot(), "tabChange")) {
            ((WebElement)PrimeSelenium.guardAjax((Object)this.getHeaders().get(index))).click();
        } else {
            this.getHeaders().get(index).click();
        }
    }

    public List<Tab> getSelectedTabs() {
        return this.getTabs().stream().filter(tab -> tab.getHeader().getAttribute("class").contains("ui-state-active")).collect(Collectors.toList());
    }
}

