/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.optimizerplugin.replacer;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.logging.Log;
import org.primefaces.extensions.optimizerplugin.replacer.TokenResolver;

public abstract class AbstractTokenReplacingReader
extends Reader {
    protected final Log log;
    protected final PushbackReader pushbackReader;
    private final TokenResolver tokenResolver;
    protected final StringBuilder tokenBuffer = new StringBuilder();
    protected String resolvedToken = null;
    protected int resolvedTokenIndex = 0;

    protected AbstractTokenReplacingReader(Log log, TokenResolver resolver, Reader source, int pushbackBufferSize) {
        this.log = log;
        this.pushbackReader = new PushbackReader(source, pushbackBufferSize);
        this.tokenResolver = Objects.requireNonNull(resolver, "Token resolver is null");
    }

    protected abstract boolean matchTokenStart() throws IOException;

    protected abstract boolean findToken() throws IOException;

    protected abstract void handleResolverResult();

    @Override
    public final int read() throws IOException {
        if (this.resolvedToken != null) {
            if (this.resolvedTokenIndex < this.resolvedToken.length()) {
                return this.resolvedToken.charAt(this.resolvedTokenIndex++);
            }
            this.resolvedToken = null;
            this.resolvedTokenIndex = 0;
        }
        if (!this.matchTokenStart()) {
            return this.pushbackReader.read();
        }
        if (this.findToken()) {
            this.resolvedToken = this.tokenResolver.resolveToken(this.tokenBuffer.toString());
            this.handleResolverResult();
        }
        return this.resolvedToken.charAt(this.resolvedTokenIndex++);
    }

    protected int readChars(char[] tmpChars) throws IOException {
        int countValidChars = -1;
        int length = tmpChars.length;
        int data = this.pushbackReader.read();
        for (int i = 0; i < length; ++i) {
            if (data != -1) {
                tmpChars[i] = (char)data;
                countValidChars = i + 1;
                if (i + 1 >= length) continue;
                data = this.pushbackReader.read();
                continue;
            }
            tmpChars[i] = '\u0000';
        }
        return countValidChars;
    }

    @Override
    public final int read(@Nonnull char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public final int read(@Nonnull char[] cbuf, int off, int len) throws IOException {
        int charsRead = 0;
        for (int i = 0; i < len; ++i) {
            int nextChar = this.read();
            if (nextChar == -1) {
                charsRead = i;
                if (charsRead != 0) break;
                charsRead = -1;
                break;
            }
            charsRead = i + 1;
            cbuf[off + i] = (char)nextChar;
        }
        return charsRead;
    }

    @Override
    public final void close() throws IOException {
        this.pushbackReader.close();
    }

    @Override
    public final boolean ready() throws IOException {
        return this.pushbackReader.ready();
    }

    @Override
    public final boolean markSupported() {
        return false;
    }

    @Override
    public final int read(@Nonnull CharBuffer target) {
        throw new UnsupportedOperationException("Method int read(CharBuffer target) is not supported");
    }

    @Override
    public final long skip(long n) {
        throw new UnsupportedOperationException("Method long skip(long n) is not supported");
    }

    @Override
    public final void mark(int readAheadLimit) {
        throw new UnsupportedOperationException("Method void mark(int readAheadLimit) is not supported");
    }

    @Override
    public final void reset() {
        throw new UnsupportedOperationException("Method void reset() is not supported");
    }
}

