/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.junit4.legacy.internal.impl.testcaseworkaround;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.junit.internal.runners.BeforeAndAfterRunner;
import org.junit.internal.runners.TestMethodRunner;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.powermock.modules.junit4.legacy.internal.impl.testcaseworkaround.PowerMockJUnit4LegacyTestIntrospector;
import org.powermock.reflect.Whitebox;
import org.powermock.tests.utils.PowerMockTestNotifier;

public class PowerMockJUnit4LegacyTestMethodRunner
extends TestMethodRunner {
    private final PowerMockJUnit4LegacyTestIntrospector testIntrospector;
    private final Method method;
    private final Description description;
    private final RunNotifier notifier;
    private final PowerMockTestNotifier powerMockTestNotifier;

    public PowerMockJUnit4LegacyTestMethodRunner(Object test, Method method, RunNotifier notifier, Description description, PowerMockTestNotifier powerMockTestNotifier) {
        super(test, method, notifier, description);
        this.method = method;
        this.description = description;
        this.notifier = notifier;
        this.powerMockTestNotifier = powerMockTestNotifier;
        this.testIntrospector = new PowerMockJUnit4LegacyTestIntrospector(test.getClass());
        Whitebox.setInternalState((Object)((Object)this), (String)"fTestIntrospector", (Object)((Object)this.testIntrospector), TestMethodRunner.class);
        Whitebox.setInternalState((Object)((Object)this), (String)"fTestIntrospector", (Object)((Object)this.testIntrospector), BeforeAndAfterRunner.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.testIntrospector.isIgnored(this.method)) {
            this.notifier.fireTestIgnored(this.description);
            return;
        }
        this.notifier.fireTestStarted(this.description);
        try {
            this.powerMockTestNotifier.notifyBeforeTestMethod(Whitebox.getInternalState((Object)((Object)this), (String)"fTest"), this.method, new Object[0]);
            long timeout = this.testIntrospector.getTimeout(this.method);
            this.executeMethodInTestInstance("setUp");
            if (timeout > 0L) {
                Whitebox.invokeMethod((Object)((Object)this), TestMethodRunner.class, (String)"runWithTimeout", (Object[])new Object[]{timeout});
            } else {
                Whitebox.invokeMethod((Object)((Object)this), TestMethodRunner.class, (String)"runMethod", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.executeMethodInTestInstance("tearDown");
            }
            finally {
                this.notifier.fireTestFinished(this.description);
            }
        }
    }

    private void executeMethodInTestInstance(String methodName) {
        if (TestCase.class.isAssignableFrom(Whitebox.getInternalState((Object)((Object)this), (String)"fTest").getClass())) {
            Object object = Whitebox.getInternalState((Object)((Object)this), (String)"fTest");
            try {
                if (object != null) {
                    Whitebox.invokeMethod((Object)object, (String)methodName, (Object[])new Object[0]);
                }
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }

    protected void runUnprotected() {
        try {
            this.executeMethodBody();
            if (this.expectsException()) {
                this.addFailure((Throwable)((Object)new AssertionError((Object)("Expected exception: " + this.expectedException().getName()))));
            }
        }
        catch (InvocationTargetException e) {
            Throwable actual = e.getTargetException();
            if (!this.expectsException()) {
                this.addFailure(actual);
            } else if (this.isUnexpected(actual)) {
                String message = "Unexpected exception, expected<" + this.expectedException().getName() + "> but was<" + actual.getClass().getName() + ">";
                this.addFailure(new Exception(message, actual));
            }
        }
        catch (Throwable e) {
            this.addFailure(e);
        }
    }

    private boolean isUnexpected(Throwable exception) {
        return !this.expectedException().isAssignableFrom(exception.getClass());
    }

    private boolean expectsException() {
        return this.expectedException() != null;
    }

    private Class<? extends Throwable> expectedException() {
        return this.testIntrospector.expectedException(this.method);
    }
}

