/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.junit3.internal.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.powermock.core.spi.PowerMockTestListener;
import org.powermock.modules.junit3.internal.JUnit3TestSuiteChunker;
import org.powermock.modules.junit3.internal.PowerMockJUnit3RunnerDelegate;
import org.powermock.modules.junit3.internal.impl.PowerMockJUnit3RunnerDelegateImpl;
import org.powermock.modules.junit3.internal.impl.PowerMockJUnit3TestListener;
import org.powermock.tests.utils.TestChunk;
import org.powermock.tests.utils.impl.AbstractTestSuiteChunkerImpl;
import org.powermock.tests.utils.impl.MockPolicyInitializerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnit3TestSuiteChunkerImpl
extends AbstractTestSuiteChunkerImpl<PowerMockJUnit3RunnerDelegate>
implements JUnit3TestSuiteChunker {
    private String name;

    public JUnit3TestSuiteChunkerImpl(Class<? extends TestCase> ... testClasses) throws Exception {
        super((Class[])testClasses);
        try {
            for (Class<? extends TestCase> testClass : testClasses) {
                this.createTestDelegators(testClass, this.getTestChunksEntries(testClass));
            }
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public JUnit3TestSuiteChunkerImpl(String name, Class<? extends TestCase> ... testClasses) throws Exception {
        this(testClasses);
        this.name = name;
    }

    protected PowerMockJUnit3RunnerDelegate createDelegatorFromClassloader(ClassLoader classLoader, Class<?> testClass, List<Method> methodsToTest) throws Exception {
        Class<?> testClassLoadedByMockedClassLoader = Class.forName(testClass.getName(), false, classLoader);
        Class<?> powerMockTestListenerArrayType = Class.forName(PowerMockTestListener[].class.getName(), false, classLoader);
        Class<?> delegateClass = Class.forName(PowerMockJUnit3RunnerDelegateImpl.class.getName(), false, classLoader);
        Constructor<?> con = delegateClass.getConstructor(Class.class, Method[].class, powerMockTestListenerArrayType);
        PowerMockJUnit3RunnerDelegate newDelegate = (PowerMockJUnit3RunnerDelegate)con.newInstance(testClassLoadedByMockedClassLoader, methodsToTest.toArray(new Method[0]), this.getPowerMockTestListenersLoadedByASpecificClassLoader(testClass, classLoader));
        newDelegate.setName(this.name);
        return newDelegate;
    }

    protected void chunkClass(Class<?> testClass) throws Exception {
        if (!TestCase.class.isAssignableFrom(testClass)) {
            throw new IllegalArgumentException(testClass.getName() + " must be a subtype of " + TestCase.class.getName());
        }
        super.chunkClass(testClass);
    }

    public int getTestCount() {
        if (this.testCount == -1) {
            this.testCount = 0;
            for (PowerMockJUnit3RunnerDelegate delegate : this.delegates) {
                this.testCount += delegate.testCount();
            }
        }
        return this.testCount;
    }

    public boolean shouldExecuteTestForMethod(Class<?> testClass, Method potentialTestMethod) {
        return potentialTestMethod.getName().startsWith("test") && Modifier.isPublic(potentialTestMethod.getModifiers()) && potentialTestMethod.getReturnType().equals(Void.TYPE);
    }

    @Override
    public void addTest(Test test) throws Exception {
        if (test == null) {
            throw new IllegalArgumentException("test cannot be null");
        }
        if (test instanceof TestCase) {
            this.addTestClassToSuite(test.getClass());
        } else if (test instanceof TestSuite) {
            Enumeration tests = ((TestSuite)test).tests();
            while (tests.hasMoreElements()) {
                this.addTest((Test)tests.nextElement());
            }
        } else {
            throw new IllegalArgumentException("The test type " + test.getClass().getName() + " is not supported. Only " + TestCase.class.getName() + " and " + TestSuite.class.getName() + " are supported.");
        }
    }

    @Override
    public void addTestSuite(Class<? extends TestCase> testClass) throws Exception {
        this.addTestClassToSuite(testClass);
    }

    @Override
    public int countTestCases() {
        int count = 0;
        for (PowerMockJUnit3RunnerDelegate delegate : this.delegates) {
            count += delegate.countTestCases();
        }
        return count;
    }

    @Override
    public void run(TestResult result) {
        Iterator<TestChunk> iterator = this.getChunkIterator();
        for (PowerMockJUnit3RunnerDelegate delegate : this.delegates) {
            TestChunk next = iterator.next();
            PowerMockJUnit3TestListener listener = new PowerMockJUnit3TestListener(next.getClassLoader());
            result.addListener((TestListener)listener);
            new MockPolicyInitializerImpl(delegate.getTestClass()).initialize(this.getClass().getClassLoader());
            delegate.run(result);
            result.removeListener((TestListener)listener);
        }
    }

    @Override
    public void runTest(Test test, TestResult result) {
        Iterator<TestChunk> iterator = this.getChunkIterator();
        for (PowerMockJUnit3RunnerDelegate delegate : this.delegates) {
            TestChunk next = iterator.next();
            PowerMockJUnit3TestListener listener = new PowerMockJUnit3TestListener(next.getClassLoader());
            result.addListener((TestListener)listener);
            delegate.runTest(test, result);
            result.removeListener((TestListener)listener);
        }
    }

    private Iterator<TestChunk> getChunkIterator() {
        List entrySet = this.getTestChunks();
        Iterator<TestChunk> iterator = entrySet.iterator();
        if (this.delegates.size() != this.getChunkSize()) {
            throw new IllegalStateException("Internal error: There must be an equal number of suites and delegates.");
        }
        return iterator;
    }

    @Override
    public Test testAt(int index) {
        return ((PowerMockJUnit3RunnerDelegate)this.delegates.get(this.getDelegatorIndex(index))).testAt(this.getInternalTestIndex(index));
    }

    @Override
    public void addTestClassToSuite(Class<?> clazz) throws Exception {
        this.chunkClass(clazz);
        if (!this.delegatesCreatedForTheseClasses.contains(clazz)) {
            try {
                this.createTestDelegators(clazz, this.getTestChunksEntries(clazz));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Enumeration<?> tests() {
        final LinkedList tests = new LinkedList();
        for (PowerMockJUnit3RunnerDelegate delegate : this.delegates) {
            Enumeration<?> delegateTests = delegate.tests();
            while (delegateTests.hasMoreElements()) {
                tests.add(delegateTests.nextElement());
            }
        }
        Enumeration<Object> allTests = new Enumeration<Object>(){
            private volatile int count = 0;

            @Override
            public boolean hasMoreElements() {
                return this.count != tests.size();
            }

            @Override
            public Object nextElement() {
                return tests.get(this.count++);
            }
        };
        return allTests;
    }
}

