/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.backend;

import io.netty.buffer.ByteBuf;
import io.r2dbc.postgresql.message.backend.BackendMessage;
import io.r2dbc.postgresql.message.backend.BackendMessageUtils;
import io.r2dbc.postgresql.util.Assert;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public final class CommandComplete
implements BackendMessage {
    private static final String[] NO_ROW_ID_TAGS = new String[]{"SELECT", "UPDATE", "DELETE", "COPY", "FETCH", "MOVE"};
    private final String command;
    private final Integer rowId;
    private final Long rows;

    public CommandComplete(String command, @Nullable Integer rowId, @Nullable Long rows) {
        this.command = Assert.requireNonNull(command, "command must not be null");
        this.rowId = rowId;
        this.rows = rows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandComplete that = (CommandComplete)o;
        return Objects.equals(this.command, that.command) && Objects.equals(this.rowId, that.rowId) && Objects.equals(this.rows, that.rows);
    }

    public String getCommand() {
        return this.command;
    }

    @Nullable
    public Integer getRowId() {
        return this.rowId;
    }

    @Nullable
    public Long getRows() {
        return this.rows;
    }

    public int hashCode() {
        return Objects.hash(this.command, this.rowId, this.rows);
    }

    public String toString() {
        return "CommandComplete{command=" + this.command + ", rowId=" + this.rowId + ", rows=" + this.rows + '}';
    }

    static CommandComplete decode(ByteBuf in) {
        Assert.requireNonNull(in, "in must not be null");
        String tag = BackendMessageUtils.readCStringUTF8(in);
        if (tag.startsWith("INSERT")) {
            int index1 = tag.indexOf(32);
            int index2 = tag.indexOf(32, index1 + 1);
            int index3 = tag.indexOf(32, index2 + 1);
            String command = tag.substring(0, index1);
            String rowId = tag.substring(index1 + 1, index2);
            String rows = tag.substring(index2 + 1, index3 != -1 ? index3 : tag.length());
            return new CommandComplete(command, Integer.parseInt(rowId), Long.parseLong(rows));
        }
        if (CommandComplete.isNoRowId(tag)) {
            int index1 = tag.indexOf(32);
            int index2 = tag.indexOf(32, index1 + 1);
            String command = tag.substring(0, index1 != -1 ? index1 : tag.length());
            String rows = index1 != -1 ? tag.substring(index1 + 1, index2 != -1 ? index2 : tag.length()) : null;
            return new CommandComplete(command, null, rows != null ? Long.valueOf(Long.parseLong(rows)) : null);
        }
        return new CommandComplete(tag, null, null);
    }

    private static boolean isNoRowId(String tag) {
        for (String noRowIdTag : NO_ROW_ID_TAGS) {
            if (!tag.startsWith(noRowIdTag)) continue;
            return true;
        }
        return false;
    }
}

