/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.r2dbc.postgresql.util.Assert;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import reactor.util.annotation.Nullable;

public abstract class Json {
    Json() {
    }

    public static Json of(ByteBuffer buffer) {
        return new JsonByteBufInput(Unpooled.wrappedBuffer((ByteBuffer)Assert.requireNonNull(buffer, "buffer must not be null")));
    }

    public static Json of(ByteBuf buffer) {
        return new JsonByteBufInput(Assert.requireNonNull(buffer, "buffer must not be null"));
    }

    public static Json of(InputStream inputStream) {
        return new JsonInputStreamInput(Assert.requireNonNull(inputStream, "inputStream must not be null"));
    }

    public static Json of(byte[] value) {
        return new JsonByteArrayInput(Assert.requireNonNull(value, "buffer must not be null"));
    }

    public static Json of(String value) {
        return new JsonByteArrayInput(Assert.requireNonNull(value, "value must not be null").getBytes(StandardCharsets.UTF_8));
    }

    @Nullable
    public abstract <T> T mapBuffer(Function<ByteBuffer, ? extends T> var1);

    @Nullable
    public abstract <T> T mapByteBuf(Function<ByteBuf, ? extends T> var1);

    @Nullable
    public abstract <T> T mapInputStream(Function<InputStream, ? extends T> var1);

    public abstract byte[] asArray();

    public abstract String asString();

    static final class JsonByteBufInput
    extends JsonInput<ByteBuf> {
        JsonByteBufInput(ByteBuf value) {
            super(value);
        }

        @Override
        public <T> T mapBuffer(Function<ByteBuffer, ? extends T> mappingFunction) {
            Assert.requireNonNull(mappingFunction, "mappingFunction must not be null");
            return mappingFunction.apply(((ByteBuf)this.value).nioBuffer());
        }

        @Override
        public <T> T mapByteBuf(Function<ByteBuf, ? extends T> mappingFunction) {
            Assert.requireNonNull(mappingFunction, "mappingFunction must not be null");
            return mappingFunction.apply((ByteBuf)this.value);
        }

        @Override
        public <T> T mapInputStream(Function<InputStream, ? extends T> mappingFunction) {
            Assert.requireNonNull(mappingFunction, "mappingFunction must not be null");
            return mappingFunction.apply((InputStream)new ByteBufInputStream((ByteBuf)this.value));
        }

        @Override
        public byte[] asArray() {
            return ByteBufUtil.getBytes((ByteBuf)((ByteBuf)this.value));
        }

        @Override
        public String asString() {
            return ((ByteBuf)this.value).toString(0, ((ByteBuf)this.value).readableBytes(), StandardCharsets.UTF_8);
        }

        public String toString() {
            return "JsonByteBufInput{" + this.asString() + '}';
        }
    }

    static final class JsonInputStreamInput
    extends JsonInput<InputStream> {
        JsonInputStreamInput(InputStream value) {
            super(value);
        }

        @Override
        public <T> T mapBuffer(Function<ByteBuffer, ? extends T> mappingFunction) {
            Assert.requireNonNull(mappingFunction, "mappingFunction must not be null");
            return mappingFunction.apply(ByteBuffer.wrap(this.asArray()));
        }

        @Override
        public <T> T mapByteBuf(Function<ByteBuf, ? extends T> mappingFunction) {
            Assert.requireNonNull(mappingFunction, "mappingFunction must not be null");
            return mappingFunction.apply(Unpooled.wrappedBuffer((byte[])this.asArray()));
        }

        @Override
        public <T> T mapInputStream(Function<InputStream, ? extends T> mappingFunction) {
            Assert.requireNonNull(mappingFunction, "mappingFunction must not be null");
            return mappingFunction.apply((InputStream)this.value);
        }

        @Override
        public byte[] asArray() {
            if (((InputStream)this.value).markSupported()) {
                ((InputStream)this.value).mark(Integer.MAX_VALUE);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            try {
                int bytesRead;
                while ((bytesRead = ((InputStream)this.value).read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
                if (((InputStream)this.value).markSupported()) {
                    ((InputStream)this.value).reset();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot read bytes from InputStream", e);
            }
            return out.toByteArray();
        }

        @Override
        public String asString() {
            return new String(this.asArray(), StandardCharsets.UTF_8);
        }

        public String toString() {
            return "JsonInputStreamInput{" + this.value + '}';
        }
    }

    static final class JsonByteArrayInput
    extends JsonInput<byte[]> {
        JsonByteArrayInput(byte[] value) {
            super(value);
        }

        @Override
        public <T> T mapBuffer(Function<ByteBuffer, ? extends T> mappingFunction) {
            Assert.requireNonNull(mappingFunction, "mappingFunction must not be null");
            return mappingFunction.apply(ByteBuffer.wrap(this.asArray()));
        }

        @Override
        public <T> T mapByteBuf(Function<ByteBuf, ? extends T> mappingFunction) {
            Assert.requireNonNull(mappingFunction, "mappingFunction must not be null");
            return mappingFunction.apply(Unpooled.wrappedBuffer((byte[])this.asArray()));
        }

        @Override
        public <T> T mapInputStream(Function<InputStream, ? extends T> mappingFunction) {
            Assert.requireNonNull(mappingFunction, "mappingFunction must not be null");
            return mappingFunction.apply(new ByteArrayInputStream(this.asArray()));
        }

        @Override
        public byte[] asArray() {
            return (byte[])this.value;
        }

        @Override
        public String asString() {
            return new String((byte[])this.value);
        }

        public String toString() {
            return "JsonByteArrayInput{" + this.asString() + '}';
        }
    }

    static final class JsonOutput
    extends Json {
        final ByteBuf buffer;
        volatile boolean released;

        JsonOutput(ByteBuf buffer) {
            this.buffer = buffer;
        }

        @Override
        public byte[] asArray() {
            this.assertNotReleased();
            try {
                byte[] bytes = new byte[this.buffer.readableBytes()];
                this.buffer.readBytes(bytes);
                byte[] byArray = bytes;
                return byArray;
            }
            finally {
                this.release();
            }
        }

        @Override
        public String asString() {
            return new String(this.asArray());
        }

        void assertNotReleased() {
            if (this.released) {
                throw new IllegalStateException("JSON is already released");
            }
        }

        @Override
        public <T> T mapBuffer(Function<ByteBuffer, ? extends T> mappingFunction) {
            this.assertNotReleased();
            ByteBuffer buffer = ByteBuffer.allocate(this.buffer.readableBytes());
            this.buffer.readBytes(buffer);
            buffer.flip();
            this.release();
            return mappingFunction.apply(buffer);
        }

        @Override
        public <T> T mapByteBuf(Function<ByteBuf, ? extends T> mappingFunction) {
            this.assertNotReleased();
            try {
                T t = mappingFunction.apply(this.buffer);
                return t;
            }
            finally {
                this.release();
            }
        }

        @Override
        public <T> T mapInputStream(Function<InputStream, ? extends T> mappingFunction) {
            this.assertNotReleased();
            try {
                T t = mappingFunction.apply((InputStream)new ByteBufInputStream(this.buffer));
                return t;
            }
            finally {
                this.release();
            }
        }

        private void release() {
            this.released = true;
            this.buffer.release();
        }

        public String toString() {
            if (this.released) {
                return "JsonOutput{[released]}";
            }
            return "JsonOutput{" + this.buffer.toString(StandardCharsets.UTF_8) + "}";
        }
    }

    static abstract class JsonInput<T>
    extends Json {
        final T value;

        JsonInput(T value) {
            this.value = value;
        }
    }
}

