/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.r2dbc.postgresql.MultiHostConnectionStrategy;
import io.r2dbc.postgresql.client.ConnectionSettings;
import io.r2dbc.postgresql.client.DefaultHostnameVerifier;
import io.r2dbc.postgresql.client.MultiHostConfiguration;
import io.r2dbc.postgresql.client.SSLConfig;
import io.r2dbc.postgresql.client.SSLMode;
import io.r2dbc.postgresql.client.SingleHostConfiguration;
import io.r2dbc.postgresql.extension.CodecRegistrar;
import io.r2dbc.postgresql.extension.Extension;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.LogLevel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import reactor.netty.resources.LoopResources;
import reactor.util.annotation.Nullable;

public final class PostgresqlConnectionConfiguration {
    public static final int DEFAULT_PORT = 5432;
    private final String applicationName;
    private final boolean autodetectExtensions;
    private final boolean compatibilityMode;
    @Nullable
    private final Duration connectTimeout;
    private final String database;
    private final LogLevel errorResponseLogLevel;
    private final List<Extension> extensions;
    private final ToIntFunction<String> fetchSize;
    private final boolean forceBinary;
    @Nullable
    private final Duration lockWaitTimeout;
    @Nullable
    private final LoopResources loopResources;
    @Nullable
    private final MultiHostConfiguration multiHostConfiguration;
    private final LogLevel noticeLogLevel;
    private final Map<String, String> options;
    private final CharSequence password;
    private final boolean preferAttachedBuffers;
    private final int preparedStatementCacheQueries;
    @Nullable
    private final SingleHostConfiguration singleHostConfiguration;
    @Nullable
    private final Duration statementTimeout;
    private final SSLConfig sslConfig;
    private final boolean tcpKeepAlive;
    private final boolean tcpNoDelay;
    private final TimeZone timeZone;
    private final String username;

    private PostgresqlConnectionConfiguration(String applicationName, boolean autodetectExtensions, @Nullable boolean compatibilityMode, @Nullable Duration connectTimeout, @Nullable String database, LogLevel errorResponseLogLevel, List<Extension> extensions, ToIntFunction<String> fetchSize, boolean forceBinary, @Nullable Duration lockWaitTimeout, @Nullable LoopResources loopResources, @Nullable MultiHostConfiguration multiHostConfiguration, LogLevel noticeLogLevel, @Nullable Map<String, String> options, @Nullable CharSequence password, boolean preferAttachedBuffers, int preparedStatementCacheQueries, @Nullable String schema, @Nullable SingleHostConfiguration singleHostConfiguration, SSLConfig sslConfig, @Nullable Duration statementTimeout, boolean tcpKeepAlive, boolean tcpNoDelay, TimeZone timeZone, String username) {
        this.applicationName = Assert.requireNonNull(applicationName, "applicationName must not be null");
        this.autodetectExtensions = autodetectExtensions;
        this.compatibilityMode = compatibilityMode;
        this.connectTimeout = connectTimeout;
        this.errorResponseLogLevel = errorResponseLogLevel;
        this.extensions = Assert.requireNonNull(extensions, "extensions must not be null");
        this.database = database;
        this.fetchSize = fetchSize;
        this.forceBinary = forceBinary;
        this.loopResources = loopResources;
        this.multiHostConfiguration = multiHostConfiguration;
        this.noticeLogLevel = noticeLogLevel;
        this.options = options == null ? new LinkedHashMap<String, String>() : new LinkedHashMap<String, String>(options);
        this.statementTimeout = statementTimeout;
        this.lockWaitTimeout = lockWaitTimeout;
        if (this.statementTimeout != null) {
            this.options.put("statement_timeout", Long.toString(statementTimeout.toMillis()));
        }
        if (this.lockWaitTimeout != null) {
            this.options.put("lock_timeout", Long.toString(lockWaitTimeout.toMillis()));
        }
        if (schema != null && !schema.isEmpty()) {
            this.options.put("search_path", schema);
        }
        this.password = password;
        this.preferAttachedBuffers = preferAttachedBuffers;
        this.preparedStatementCacheQueries = preparedStatementCacheQueries;
        this.singleHostConfiguration = singleHostConfiguration;
        this.sslConfig = sslConfig;
        this.tcpKeepAlive = tcpKeepAlive;
        this.tcpNoDelay = tcpNoDelay;
        this.timeZone = timeZone;
        this.username = Assert.requireNonNull(username, "username must not be null");
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "PostgresqlConnectionConfiguration{applicationName='" + this.applicationName + '\'' + ", autodetectExtensions='" + this.autodetectExtensions + '\'' + ", compatibilityMode=" + this.compatibilityMode + ", connectTimeout=" + this.connectTimeout + ", errorResponseLogLevel=" + (Object)((Object)this.errorResponseLogLevel) + ", database='" + this.database + '\'' + ", extensions=" + this.extensions + ", fetchSize=" + this.fetchSize + ", forceBinary='" + this.forceBinary + '\'' + ", lockWaitTimeout='" + this.lockWaitTimeout + ", loopResources='" + this.loopResources + '\'' + ", multiHostConfiguration='" + this.multiHostConfiguration + '\'' + ", noticeLogLevel='" + (Object)((Object)this.noticeLogLevel) + '\'' + ", options='" + this.options + '\'' + ", password='" + PostgresqlConnectionConfiguration.obfuscate(this.password != null ? this.password.length() : 0) + '\'' + ", preferAttachedBuffers=" + this.preferAttachedBuffers + ", singleHostConfiguration=" + this.singleHostConfiguration + ", statementTimeout=" + this.statementTimeout + ", tcpKeepAlive=" + this.tcpKeepAlive + ", tcpNoDelay=" + this.tcpNoDelay + ", timeZone=" + this.timeZone + ", username='" + this.username + '\'' + '}';
    }

    String getApplicationName() {
        return this.applicationName;
    }

    boolean isCompatibilityMode() {
        return this.compatibilityMode;
    }

    @Nullable
    Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Nullable
    String getDatabase() {
        return this.database;
    }

    List<Extension> getExtensions() {
        return this.extensions;
    }

    ToIntFunction<String> getFetchSize() {
        return this.fetchSize;
    }

    int getFetchSize(String sql) {
        return this.fetchSize.applyAsInt(sql);
    }

    @Nullable
    MultiHostConfiguration getMultiHostConfiguration() {
        return this.multiHostConfiguration;
    }

    MultiHostConfiguration getRequiredMultiHostConfiguration() {
        MultiHostConfiguration config = this.getMultiHostConfiguration();
        if (config == null) {
            throw new IllegalStateException("MultiHostConfiguration not configured");
        }
        return config;
    }

    Map<String, String> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    @Nullable
    CharSequence getPassword() {
        return this.password;
    }

    boolean isPreferAttachedBuffers() {
        return this.preferAttachedBuffers;
    }

    int getPreparedStatementCacheQueries() {
        return this.preparedStatementCacheQueries;
    }

    @Nullable
    SingleHostConfiguration getSingleHostConfiguration() {
        return this.singleHostConfiguration;
    }

    SingleHostConfiguration getRequiredSingleHostConfiguration() {
        SingleHostConfiguration config = this.getSingleHostConfiguration();
        if (config == null) {
            throw new IllegalStateException("SingleHostConfiguration not configured");
        }
        return config;
    }

    String getUsername() {
        return this.username;
    }

    boolean isAutodetectExtensions() {
        return this.autodetectExtensions;
    }

    boolean isForceBinary() {
        return this.forceBinary;
    }

    boolean isTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    TimeZone getTimeZone() {
        return this.timeZone;
    }

    SSLConfig getSslConfig() {
        return this.sslConfig;
    }

    ConnectionSettings getConnectionSettings() {
        return ConnectionSettings.builder().connectTimeout(this.getConnectTimeout()).errorResponseLogLevel(this.errorResponseLogLevel).noticeLogLevel(this.noticeLogLevel).sslConfig(this.getSslConfig()).startupOptions(this.options).tcpKeepAlive(this.isTcpKeepAlive()).tcpNoDelay(this.isTcpNoDelay()).loopResources(this.loopResources).build();
    }

    private static String obfuscate(int length) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append("*");
        }
        return builder.toString();
    }

    static class FixedFetchSize
    implements ToIntFunction<String> {
        private final int fetchSize;

        public FixedFetchSize(int fetchSize) {
            this.fetchSize = fetchSize;
        }

        @Override
        public int applyAsInt(String value) {
            return this.fetchSize;
        }

        public String toString() {
            return "" + this.fetchSize;
        }
    }

    public static final class Builder {
        private String applicationName = "r2dbc-postgresql";
        private boolean autodetectExtensions = true;
        private boolean compatibilityMode = false;
        @Nullable
        private Duration connectTimeout;
        @Nullable
        private String database;
        private LogLevel errorResponseLogLevel = LogLevel.DEBUG;
        private final List<Extension> extensions = new ArrayList<Extension>();
        private ToIntFunction<String> fetchSize = sql -> 0;
        private boolean forceBinary = false;
        @Nullable
        private Duration lockWaitTimeout;
        @Nullable
        private MultiHostConfiguration.Builder multiHostConfiguration;
        private LogLevel noticeLogLevel = LogLevel.DEBUG;
        private Map<String, String> options;
        @Nullable
        private CharSequence password;
        private boolean preferAttachedBuffers = false;
        private int preparedStatementCacheQueries = -1;
        @Nullable
        private String schema;
        @Nullable
        private SingleHostConfiguration.Builder singleHostConfiguration;
        @Nullable
        private URL sslCert = null;
        private HostnameVerifier sslHostnameVerifier = DefaultHostnameVerifier.INSTANCE;
        @Nullable
        private URL sslKey = null;
        private SSLMode sslMode = SSLMode.DISABLE;
        @Nullable
        private CharSequence sslPassword = null;
        @Nullable
        private URL sslRootCert = null;
        @Nullable
        private Duration statementTimeout = null;
        private Function<SslContextBuilder, SslContextBuilder> sslContextBuilderCustomizer = Function.identity();
        private boolean tcpKeepAlive = false;
        private boolean tcpNoDelay = true;
        private TimeZone timeZone = TimeZone.getDefault();
        @Nullable
        private LoopResources loopResources = null;
        @Nullable
        private String username;

        private Builder() {
        }

        public Builder applicationName(String applicationName) {
            this.applicationName = Assert.requireNonNull(applicationName, "applicationName must not be null");
            return this;
        }

        public Builder autodetectExtensions(boolean autodetectExtensions) {
            this.autodetectExtensions = autodetectExtensions;
            return this;
        }

        public PostgresqlConnectionConfiguration build() {
            MultiHostConfiguration multiHostConfiguration;
            SingleHostConfiguration singleHostConfiguration = this.singleHostConfiguration != null ? this.singleHostConfiguration.build() : null;
            if (singleHostConfiguration == null == ((multiHostConfiguration = this.multiHostConfiguration != null ? this.multiHostConfiguration.build() : null) == null)) {
                throw new IllegalArgumentException("Connection must be configured for either multi-host or single host connectivity");
            }
            if (this.username == null) {
                throw new IllegalArgumentException("username must not be null");
            }
            return new PostgresqlConnectionConfiguration(this.applicationName, this.autodetectExtensions, this.compatibilityMode, this.connectTimeout, this.database, this.errorResponseLogLevel, this.extensions, this.fetchSize, this.forceBinary, this.lockWaitTimeout, this.loopResources, multiHostConfiguration, this.noticeLogLevel, this.options, this.password, this.preferAttachedBuffers, this.preparedStatementCacheQueries, this.schema, singleHostConfiguration, this.createSslConfig(), this.statementTimeout, this.tcpKeepAlive, this.tcpNoDelay, this.timeZone, this.username);
        }

        public Builder compatibilityMode(boolean compatibilityMode) {
            this.compatibilityMode = compatibilityMode;
            return this;
        }

        public Builder connectTimeout(@Nullable Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder codecRegistrar(CodecRegistrar codecRegistrar) {
            return this.extendWith(codecRegistrar);
        }

        public Builder database(@Nullable String database) {
            this.database = database;
            return this;
        }

        public Builder enableSsl() {
            return this.sslMode(SSLMode.VERIFY_FULL);
        }

        public Builder extendWith(Extension extension) {
            this.extensions.add(Assert.requireNonNull(extension, "extension must not be null"));
            return this;
        }

        public Builder errorResponseLogLevel(LogLevel errorResponseLogLevel) {
            this.errorResponseLogLevel = Assert.requireNonNull(errorResponseLogLevel, "errorResponseLogLevel must not be null");
            return this;
        }

        public Builder fetchSize(int fetchSize) {
            Assert.isTrue(fetchSize >= 0, "fetch size must be greater or equal zero");
            return this.fetchSize(new FixedFetchSize(fetchSize));
        }

        public Builder fetchSize(ToIntFunction<String> fetchSizeFunction) {
            Assert.requireNonNull(fetchSizeFunction, "fetch size function must be non null");
            this.fetchSize = fetchSizeFunction;
            return this;
        }

        public Builder forceBinary(boolean forceBinary) {
            this.forceBinary = forceBinary;
            return this;
        }

        public Builder host(String host) {
            Assert.requireNonNull(host, "host must not be null");
            this.prepareSingleHostConfiguration().host(host);
            return this;
        }

        public Builder addHost(String host) {
            Assert.requireNonNull(host, "host must not be null");
            this.prepareMultiHostConfiguration().addHost(host);
            return this;
        }

        public Builder addHost(String host, int port) {
            Assert.requireNonNull(host, "host must not be null");
            this.prepareMultiHostConfiguration().addHost(host, port);
            return this;
        }

        public Builder hostRecheckTime(Duration hostRecheckTime) {
            this.prepareMultiHostConfiguration().hostRecheckTime(hostRecheckTime);
            return this;
        }

        public Builder loadBalanceHosts(boolean loadBalanceHosts) {
            this.prepareMultiHostConfiguration().loadBalanceHosts(loadBalanceHosts);
            return this;
        }

        public Builder lockWaitTimeout(Duration lockWaitTimeout) {
            this.lockWaitTimeout = Assert.requireNonNull(lockWaitTimeout, "Lock wait timeout must not be null");
            return this;
        }

        public Builder loopResources(LoopResources loopResources) {
            this.loopResources = Assert.requireNonNull(loopResources, "loopResources must not be null");
            return this;
        }

        public Builder noticeLogLevel(LogLevel noticeLogLevel) {
            this.noticeLogLevel = Assert.requireNonNull(noticeLogLevel, "noticeLogLevel must not be null");
            return this;
        }

        public Builder options(Map<String, String> options) {
            Assert.requireNonNull(options, "options map must not be null");
            options.forEach((k, v) -> {
                Assert.requireNonNull(k, "option keys must not be null");
                Assert.requireNonNull(v, "option values must not be null");
            });
            this.options = options;
            return this;
        }

        public Builder password(@Nullable CharSequence password) {
            this.password = password;
            return this;
        }

        public Builder port(int port) {
            this.prepareSingleHostConfiguration().port(port);
            return this;
        }

        public Builder preferAttachedBuffers(boolean preferAttachedBuffers) {
            this.preferAttachedBuffers = preferAttachedBuffers;
            return this;
        }

        public Builder preparedStatementCacheQueries(int preparedStatementCacheQueries) {
            this.preparedStatementCacheQueries = preparedStatementCacheQueries;
            return this;
        }

        public Builder schema(@Nullable String schema) {
            this.schema = schema;
            return this;
        }

        public Builder socket(String socket) {
            Assert.requireNonNull(socket, "host must not be null");
            this.prepareSingleHostConfiguration().socket(socket);
            this.sslMode(SSLMode.DISABLE);
            return this;
        }

        public Builder sslContextBuilderCustomizer(Function<SslContextBuilder, SslContextBuilder> sslContextBuilderCustomizer) {
            this.sslContextBuilderCustomizer = Assert.requireNonNull(sslContextBuilderCustomizer, "sslContextBuilderCustomizer must not be null");
            return this;
        }

        public Builder sslCert(String sslCert) {
            return this.sslCert(this.requireExistingFilePath(sslCert, "sslCert must not be null and must exist"));
        }

        public Builder sslCert(URL sslCert) {
            this.sslCert = Assert.requireNonNull(sslCert, "sslCert must not be null");
            return this;
        }

        public Builder sslHostnameVerifier(HostnameVerifier sslHostnameVerifier) {
            this.sslHostnameVerifier = Assert.requireNonNull(sslHostnameVerifier, "sslHostnameVerifier must not be null");
            return this;
        }

        public Builder sslKey(String sslKey) {
            return this.sslKey(this.requireExistingFilePath(sslKey, "sslKey must not be null and must exist"));
        }

        public Builder sslKey(URL sslKey) {
            this.sslKey = Assert.requireNonNull(sslKey, "sslKey must not be null");
            return this;
        }

        public Builder sslMode(SSLMode sslMode) {
            this.sslMode = Assert.requireNonNull(sslMode, "sslMode must be not be null");
            return this;
        }

        public Builder sslPassword(@Nullable CharSequence sslPassword) {
            this.sslPassword = sslPassword;
            return this;
        }

        public Builder sslRootCert(String sslRootCert) {
            return this.sslRootCert(this.requireExistingFilePath(sslRootCert, "sslRootCert must not be null and must exist"));
        }

        public Builder sslRootCert(URL sslRootCert) {
            this.sslRootCert = Assert.requireNonNull(sslRootCert, "sslRootCert must not be null and must exist");
            return this;
        }

        public Builder statementTimeout(Duration statementTimeout) {
            this.statementTimeout = Assert.requireNonNull(statementTimeout, "Statement timeout");
            return this;
        }

        public Builder targetServerType(MultiHostConnectionStrategy.TargetServerType targetServerType) {
            this.prepareMultiHostConfiguration().targetServerType(targetServerType);
            return this;
        }

        public Builder tcpKeepAlive(boolean enabled) {
            this.tcpKeepAlive = enabled;
            return this;
        }

        public Builder tcpNoDelay(boolean enabled) {
            this.tcpNoDelay = enabled;
            return this;
        }

        public Builder timeZone(String timeZone) {
            return this.timeZone(TimeZone.getTimeZone(Assert.requireNotEmpty(timeZone, "timeZone must not be empty")));
        }

        public Builder timeZone(TimeZone timeZone) {
            this.timeZone = Assert.requireNonNull(timeZone, "timeZone must not be null");
            return this;
        }

        public Builder username(String username) {
            this.username = Assert.requireNonNull(username, "username must not be null");
            return this;
        }

        public String toString() {
            return "Builder{applicationName='" + this.applicationName + '\'' + ", autodetectExtensions='" + this.autodetectExtensions + '\'' + ", compatibilityMode='" + this.compatibilityMode + '\'' + ", connectTimeout='" + this.connectTimeout + '\'' + ", database='" + this.database + '\'' + ", extensions='" + this.extensions + '\'' + ", errorResponseLogLevel='" + (Object)((Object)this.errorResponseLogLevel) + '\'' + ", fetchSize='" + this.fetchSize + '\'' + ", forceBinary='" + this.forceBinary + '\'' + ", lockWaitTimeout='" + this.lockWaitTimeout + '\'' + ", loopResources='" + this.loopResources + '\'' + ", multiHostConfiguration='" + this.multiHostConfiguration + '\'' + ", noticeLogLevel='" + (Object)((Object)this.noticeLogLevel) + '\'' + ", parameters='" + this.options + '\'' + ", password='" + PostgresqlConnectionConfiguration.obfuscate(this.password != null ? this.password.length() : 0) + '\'' + ", preparedStatementCacheQueries='" + this.preparedStatementCacheQueries + '\'' + ", schema='" + this.schema + '\'' + ", singleHostConfiguration='" + this.singleHostConfiguration + '\'' + ", sslContextBuilderCustomizer='" + this.sslContextBuilderCustomizer + '\'' + ", sslMode='" + (Object)((Object)this.sslMode) + '\'' + ", sslRootCert='" + this.sslRootCert + '\'' + ", sslCert='" + this.sslCert + '\'' + ", sslKey='" + this.sslKey + '\'' + ", statementTimeout='" + this.statementTimeout + '\'' + ", sslHostnameVerifier='" + this.sslHostnameVerifier + '\'' + ", tcpKeepAlive='" + this.tcpKeepAlive + '\'' + ", tcpNoDelay='" + this.tcpNoDelay + '\'' + ", timeZone='" + this.timeZone + '\'' + ", username='" + this.username + '\'' + '}';
        }

        private SSLConfig createSslConfig() {
            if (this.singleHostConfiguration != null && this.singleHostConfiguration.getSocket() != null || this.sslMode == SSLMode.DISABLE) {
                return SSLConfig.disabled();
            }
            HostnameVerifier hostnameVerifier = this.sslHostnameVerifier;
            return new SSLConfig(this.sslMode, this.createSslProvider(), hostnameVerifier);
        }

        private Supplier<SslContext> createSslProvider() {
            String pathname;
            SslContextBuilder sslContextBuilder = SslContextBuilder.forClient();
            if (this.sslMode.verifyCertificate()) {
                if (this.sslRootCert != null) {
                    this.doWithStream(this.sslRootCert, arg_0 -> ((SslContextBuilder)sslContextBuilder).trustManager(arg_0));
                }
            } else {
                sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            }
            sslContextBuilder.sslProvider(OpenSsl.isAvailable() ? SslProvider.OPENSSL : SslProvider.JDK).ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE).applicationProtocolConfig(null);
            URL sslKey = this.sslKey;
            URL sslCert = this.sslCert;
            String pathSeparator = System.getProperty("file.separator");
            String defaultDir = System.getProperty("os.name").toLowerCase().contains("windows") ? System.getenv("APPDATA") + pathSeparator + "postgresql" + pathSeparator : System.getProperty("user.home") + pathSeparator + ".postgresql" + pathSeparator;
            if (sslCert == null) {
                pathname = defaultDir + "postgresql.crt";
                sslCert = this.resolveUrlFromFile(pathname);
            }
            if (sslKey == null) {
                pathname = defaultDir + "postgresql.pk8";
                sslKey = this.resolveUrlFromFile(pathname);
            }
            URL sslKeyToUse = sslKey;
            if (sslKey != null && sslCert != null) {
                String sslPassword = this.sslPassword == null ? null : this.sslPassword.toString();
                this.doWithStream(sslCert, certStream -> this.doWithStream(sslKeyToUse, keyStream -> sslContextBuilder.keyManager(certStream, keyStream, sslPassword)));
            }
            return () -> {
                try {
                    return this.sslContextBuilderCustomizer.apply(sslContextBuilder).build();
                }
                catch (SSLException e) {
                    throw new IllegalStateException("Failed to create SslContext", e);
                }
            };
        }

        private SingleHostConfiguration.Builder prepareSingleHostConfiguration() {
            if (this.multiHostConfiguration != null) {
                throw new IllegalStateException("Cannot configure single-host properties because the builder is already configured with a multi-host configuration.");
            }
            if (this.singleHostConfiguration == null) {
                this.singleHostConfiguration = SingleHostConfiguration.builder();
            }
            return this.singleHostConfiguration;
        }

        private MultiHostConfiguration.Builder prepareMultiHostConfiguration() {
            if (this.singleHostConfiguration != null) {
                throw new IllegalStateException("Cannot configure multi-host properties because the builder is already configured with a single-host configuration.");
            }
            if (this.multiHostConfiguration == null) {
                this.multiHostConfiguration = MultiHostConfiguration.builder();
            }
            return this.multiHostConfiguration;
        }

        private void doWithStream(URL url, StreamConsumer consumer) {
            try (InputStream is = url.openStream();){
                consumer.doWithStream(is);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error while reading " + url, e);
            }
        }

        private URL requireExistingFilePath(String path, String message) {
            Assert.requireNonNull(path, message);
            URL resource = this.getClass().getClassLoader().getResource(path);
            if (resource != null) {
                return resource;
            }
            if (!new File(path).exists()) {
                throw new IllegalArgumentException(message);
            }
            return this.resolveUrlFromFile(path);
        }

        private URL resolveUrlFromFile(String pathname) {
            File file = new File(pathname);
            if (file.exists()) {
                try {
                    return file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(String.format("Malformed error occurred during creating URL from %s", pathname));
                }
            }
            return null;
        }

        static interface StreamConsumer {
            public void doWithStream(InputStream var1) throws IOException;
        }
    }
}

