/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.codec.AbstractTemporalCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import reactor.util.annotation.Nullable;

final class LocalDateCodec
extends AbstractTemporalCodec<LocalDate> {
    LocalDateCodec(ByteBufAllocator byteBufAllocator) {
        super(LocalDate.class, byteBufAllocator, PostgresqlObjectId.DATE, PostgresqlObjectId.DATE_ARRAY, LocalDate::toString);
    }

    @Override
    LocalDate doDecode(ByteBuf buffer, PostgresTypeIdentifier dataType, @Nullable Format format, Class<? extends LocalDate> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        return this.decodeTemporal(buffer, dataType, format, LocalDate.class, temporal -> {
            if (temporal instanceof LocalDateTime) {
                return ((LocalDateTime)temporal).toLocalDate();
            }
            return Instant.from(temporal).atOffset(ZoneOffset.UTC).toLocalDate();
        });
    }
}

