/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.r2dbc.postgresql.extension.Extension;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import reactor.util.Logger;
import reactor.util.Loggers;

final class Extensions {
    private static final Logger logger = Loggers.getLogger(Extensions.class);
    private final List<Extension> extensions;

    private Extensions(List<Extension> extensions) {
        this.extensions = extensions;
    }

    static Extensions from(Collection<Extension> extensions) {
        return new Extensions(new ArrayList<Extension>(extensions));
    }

    static Extensions autodetect() {
        logger.debug("Discovering Extensions using ServiceLoader");
        ServiceLoader extensions = AccessController.doPrivileged(() -> ServiceLoader.load(Extension.class, Extensions.class.getClassLoader()));
        ArrayList<Extension> discovered = new ArrayList<Extension>();
        for (Extension extension : extensions) {
            logger.debug("Registering extension {}", new Object[]{extension.getClass().getName()});
            discovered.add(extension);
        }
        return new Extensions(discovered);
    }

    <T extends Extension> void forEach(Class<T> extensionType, Consumer<T> consumer) {
        for (Extension extension : this.extensions) {
            if (!extensionType.isInstance(extension)) continue;
            consumer.accept(extensionType.cast(extension));
        }
    }

    Extensions mergeWith(Extensions other) {
        ArrayList<Extension> extensions = new ArrayList<Extension>(this.size() + other.size());
        extensions.addAll(this.extensions);
        extensions.addAll(other.extensions);
        return new Extensions(extensions);
    }

    public int size() {
        return this.extensions.size();
    }
}

