/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractTemporalCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.time.ZonedDateTime;
import reactor.util.annotation.Nullable;

final class ZonedDateTimeCodec
extends AbstractTemporalCodec<ZonedDateTime> {
    private final ByteBufAllocator byteBufAllocator;

    ZonedDateTimeCodec(ByteBufAllocator byteBufAllocator) {
        super(ZonedDateTime.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    public EncodedParameter encodeNull() {
        return ZonedDateTimeCodec.createNull(Format.FORMAT_TEXT, PostgresqlObjectId.TIMESTAMPTZ);
    }

    @Override
    ZonedDateTime doDecode(ByteBuf buffer, PostgresqlObjectId dataType, @Nullable Format format, Class<? extends ZonedDateTime> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        return this.decodeTemporal(buffer, dataType, format, ZonedDateTime.class, ZonedDateTime::from);
    }

    @Override
    EncodedParameter doEncode(ZonedDateTime value) {
        return this.doEncode(value, (PostgresTypeIdentifier)PostgresqlObjectId.TIMESTAMPTZ);
    }

    @Override
    EncodedParameter doEncode(ZonedDateTime value, PostgresTypeIdentifier dataType) {
        Assert.requireNonNull(value, "value must not be null");
        return ZonedDateTimeCodec.create(Format.FORMAT_TEXT, dataType, () -> ByteBufUtils.encode(this.byteBufAllocator, value.toOffsetDateTime().toString()));
    }

    @Override
    PostgresqlObjectId getDefaultType() {
        return null;
    }
}

