/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import reactor.util.annotation.Nullable;

final class StringCodec
extends AbstractCodec<String> {
    private final ByteBufAllocator byteBufAllocator;

    StringCodec(ByteBufAllocator byteBufAllocator) {
        super(String.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    public EncodedParameter encodeNull() {
        return StringCodec.createNull(Format.FORMAT_TEXT, PostgresqlObjectId.VARCHAR);
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return PostgresqlObjectId.BPCHAR == type || PostgresqlObjectId.CHAR == type || PostgresqlObjectId.TEXT == type || PostgresqlObjectId.UNKNOWN == type || PostgresqlObjectId.VARCHAR == type || PostgresqlObjectId.NAME == type;
    }

    @Override
    String doDecode(ByteBuf buffer, PostgresqlObjectId dataType, @Nullable Format format, @Nullable Class<? extends String> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        return ByteBufUtils.decode(buffer);
    }

    @Override
    EncodedParameter doEncode(String value) {
        return this.doEncode(value, (PostgresTypeIdentifier)PostgresqlObjectId.VARCHAR);
    }

    @Override
    EncodedParameter doEncode(String value, PostgresTypeIdentifier dataType) {
        Assert.requireNonNull(value, "value must not be null");
        return StringCodec.create(Format.FORMAT_TEXT, dataType, () -> ByteBufUtils.encode(this.byteBufAllocator, value));
    }
}

