/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.codec.AbstractGeometryCodec;
import io.r2dbc.postgresql.codec.Point;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;

final class PointCodec
extends AbstractGeometryCodec<Point> {
    PointCodec(ByteBufAllocator byteBufAllocator) {
        super(Point.class, PostgresqlObjectId.POINT, byteBufAllocator);
    }

    @Override
    Point doDecodeBinary(ByteBuf byteBuffer) {
        return Point.of(byteBuffer.readDouble(), byteBuffer.readDouble());
    }

    @Override
    Point doDecodeText(String text) {
        AbstractGeometryCodec.TokenStream stream = this.getTokenStream(text);
        return Point.of(stream.nextDouble(), stream.nextDouble());
    }

    @Override
    ByteBuf doEncodeBinary(Point value) {
        return this.byteBufAllocator.buffer(this.lengthInBytes()).writeDouble(value.getX()).writeDouble(value.getY());
    }

    int lengthInBytes() {
        return 16;
    }
}

