/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.codec.AbstractGeometryCodec;
import io.r2dbc.postgresql.codec.Lseg;
import io.r2dbc.postgresql.codec.Point;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;

final class LsegCodec
extends AbstractGeometryCodec<Lseg> {
    LsegCodec(ByteBufAllocator byteBufAllocator) {
        super(Lseg.class, PostgresqlObjectId.LSEG, byteBufAllocator);
    }

    @Override
    Lseg doDecodeBinary(ByteBuf byteBuffer) {
        return Lseg.of(Point.of(byteBuffer.readDouble(), byteBuffer.readDouble()), Point.of(byteBuffer.readDouble(), byteBuffer.readDouble()));
    }

    @Override
    Lseg doDecodeText(String text) {
        AbstractGeometryCodec.TokenStream stream = this.getTokenStream(text);
        return Lseg.of(Point.of(stream.nextDouble(), stream.nextDouble()), Point.of(stream.nextDouble(), stream.nextDouble()));
    }

    @Override
    ByteBuf doEncodeBinary(Lseg value) {
        return this.byteBufAllocator.buffer(32).writeDouble(value.getP1().getX()).writeDouble(value.getP1().getY()).writeDouble(value.getP2().getX()).writeDouble(value.getP2().getY());
    }
}

