/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractJsonCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import java.io.IOException;
import java.io.InputStream;

final class JsonInputStreamCodec
extends AbstractJsonCodec<InputStream> {
    private final ByteBufAllocator byteBufAllocator;

    JsonInputStreamCodec(ByteBufAllocator byteBufAllocator) {
        super(InputStream.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    InputStream doDecode(ByteBuf buffer, PostgresqlObjectId dataType, Format format, Class<? extends InputStream> type) {
        return new ByteBufInputStream(buffer.retain().touch((Object)"Decoded by JsonInputStreamCodec"), true);
    }

    @Override
    EncodedParameter doEncode(InputStream value) {
        return this.doEncode(value, (PostgresTypeIdentifier)PostgresqlObjectId.JSONB);
    }

    @Override
    EncodedParameter doEncode(InputStream value, PostgresTypeIdentifier dataType) {
        Assert.requireNonNull(value, "value must not be null");
        return JsonInputStreamCodec.create(Format.FORMAT_BINARY, dataType, () -> JsonInputStreamCodec.doEncode(value, this.byteBufAllocator));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static ByteBuf doEncode(InputStream value, ByteBufAllocator alloc) {
        try (InputStream in = value;){
            int bytesRead;
            ByteBuf json = alloc.buffer();
            byte[] buffer = new byte[4096];
            while ((bytesRead = in.read(buffer)) != -1) {
                json.writeBytes(buffer, 0, bytesRead);
            }
            ByteBuf byteBuf = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{1}), json});
            return byteBuf;
        }
        catch (IOException e) {
            throw new R2dbcNonTransientResourceException("Cannot write InputStream", (Throwable)e);
        }
    }
}

