/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractTemporalCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import reactor.util.annotation.Nullable;

final class InstantCodec
extends AbstractTemporalCodec<Instant> {
    private final ByteBufAllocator byteBufAllocator;

    InstantCodec(ByteBufAllocator byteBufAllocator) {
        super(Instant.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    public EncodedParameter encodeNull() {
        return InstantCodec.createNull(Format.FORMAT_TEXT, PostgresqlObjectId.TIMESTAMPTZ);
    }

    @Override
    Instant doDecode(ByteBuf buffer, PostgresqlObjectId dataType, @Nullable Format format, Class<? extends Instant> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        return this.decodeTemporal(buffer, dataType, format, Instant.class, temporal -> {
            if (temporal instanceof LocalDateTime) {
                return ((LocalDateTime)temporal).toInstant(ZoneOffset.UTC);
            }
            if (temporal instanceof LocalDate) {
                return ((LocalDate)temporal).atStartOfDay(ZoneId.systemDefault()).toInstant();
            }
            return Instant.from(temporal);
        });
    }

    @Override
    EncodedParameter doEncode(Instant value) {
        return this.doEncode(value, (PostgresTypeIdentifier)PostgresqlObjectId.TIMESTAMPTZ);
    }

    @Override
    EncodedParameter doEncode(Instant value, PostgresTypeIdentifier dataType) {
        Assert.requireNonNull(value, "value must not be null");
        return InstantCodec.create(Format.FORMAT_TEXT, dataType, () -> ByteBufUtils.encode(this.byteBufAllocator, value.toString()));
    }

    @Override
    PostgresqlObjectId getDefaultType() {
        return null;
    }
}

