/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractBinaryCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;

final class BinaryByteArrayCodec
extends AbstractBinaryCodec<byte[]> {
    BinaryByteArrayCodec(ByteBufAllocator byteBufAllocator) {
        super(byte[].class, byteBufAllocator);
    }

    @Override
    byte[] doDecode(ByteBuf buffer, PostgresqlObjectId dataType, Format format, Class<? extends byte[]> type) {
        return this.decode(format, buffer);
    }

    @Override
    EncodedParameter doEncode(byte[] value, PostgresTypeIdentifier dataType) {
        Assert.requireNonNull(value, "value must not be null");
        return BinaryByteArrayCodec.create(Format.FORMAT_TEXT, dataType, () -> this.encodeToHex(Unpooled.wrappedBuffer((byte[])value)));
    }
}

