/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractArrayCodec;
import io.r2dbc.postgresql.codec.NumericDecodeUtils;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import java.math.BigDecimal;
import java.util.function.Supplier;

final class BigDecimalArrayCodec
extends AbstractArrayCodec<BigDecimal> {
    public BigDecimalArrayCodec(ByteBufAllocator byteBufAllocator) {
        super(byteBufAllocator, BigDecimal.class, PostgresqlObjectId.NUMERIC_ARRAY);
    }

    @Override
    BigDecimal doDecodeBinary(ByteBuf byteBuffer) {
        return NumericDecodeUtils.decodeBinary(byteBuffer);
    }

    @Override
    BigDecimal doDecodeText(String text) {
        return new BigDecimal(text);
    }

    @Override
    String doEncodeText(BigDecimal value) {
        Assert.requireNonNull(value, "value must not be null");
        return value.toString();
    }

    @Override
    EncodedParameter encodeArray(Supplier<ByteBuf> encodedSupplier, PostgresTypeIdentifier dataType) {
        return BigDecimalArrayCodec.create(Format.FORMAT_TEXT, dataType, encodedSupplier);
    }
}

