/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;

abstract class AbstractJsonCodec<T>
extends AbstractCodec<T> {
    AbstractJsonCodec(Class<T> type) {
        super(type);
    }

    @Override
    EncodedParameter doEncode(T value) {
        return this.doEncode(value, PostgresqlObjectId.JSON);
    }

    @Override
    public EncodedParameter encodeNull() {
        return AbstractJsonCodec.createNull(Format.FORMAT_BINARY, PostgresqlObjectId.JSONB);
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return PostgresqlObjectId.JSONB == type || PostgresqlObjectId.JSON == type;
    }
}

