/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.r2dbc.postgresql.ExceptionFactory;
import io.r2dbc.postgresql.StatementCache;
import io.r2dbc.postgresql.client.Binding;
import io.r2dbc.postgresql.client.Client;
import io.r2dbc.postgresql.client.ExtendedQueryMessageFlow;
import io.r2dbc.postgresql.util.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

final class BoundedStatementCache
implements StatementCache {
    private static final Logger LOGGER = Loggers.getLogger(BoundedStatementCache.class);
    private final Map<CacheKey, String> cache = new LinkedHashMap<CacheKey, String>(16, 0.75f, true);
    private final Client client;
    private final AtomicInteger counter = new AtomicInteger();
    private final int limit;

    public BoundedStatementCache(Client client, int limit) {
        this.client = Assert.requireNonNull(client, "client must not be null");
        if (limit <= 0) {
            throw new IllegalArgumentException("statement cache limit must be greater than zero");
        }
        this.limit = limit;
    }

    @Override
    public String getName(Binding binding, String sql) {
        Assert.requireNonNull(binding, "binding must not be null");
        Assert.requireNonNull(sql, "sql must not be null");
        String name = this.get(new CacheKey(sql, binding.getParameterTypes()));
        if (name != null) {
            return name;
        }
        return "S_" + this.counter.getAndIncrement();
    }

    @Override
    public boolean requiresPrepare(Binding binding, String sql) {
        Assert.requireNonNull(binding, "binding must not be null");
        Assert.requireNonNull(sql, "sql must not be null");
        return this.get(new CacheKey(sql, binding.getParameterTypes())) == null;
    }

    @Override
    public void put(Binding binding, String sql, String name) {
        CacheKey key = new CacheKey(sql, binding.getParameterTypes());
        this.put(key, name);
        if (this.getCacheSize() <= this.limit) {
            return;
        }
        Map.Entry<CacheKey, String> lastAccessedStatement = this.getAndRemoveEldest();
        ExceptionFactory factory = ExceptionFactory.withSql(lastAccessedStatement.getKey().sql);
        ExtendedQueryMessageFlow.closeStatement(this.client, lastAccessedStatement.getValue()).handle(factory::handleErrorResponse).subscribe(it -> {}, err -> LOGGER.warn(String.format("Cannot close statement %s (%s)", lastAccessedStatement.getValue(), ((CacheKey)lastAccessedStatement.getKey()).sql), err));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<String> getCachedStatementNames() {
        Map<CacheKey, String> map = this.cache;
        synchronized (map) {
            ArrayList<String> names = new ArrayList<String>(this.cache.size());
            names.addAll(this.cache.values());
            return names;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String get(CacheKey key) {
        Map<CacheKey, String> map = this.cache;
        synchronized (map) {
            return this.cache.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map.Entry<CacheKey, String> getAndRemoveEldest() {
        Map<CacheKey, String> map = this.cache;
        synchronized (map) {
            Iterator<Map.Entry<CacheKey, String>> iterator = this.cache.entrySet().iterator();
            Map.Entry<CacheKey, String> entry = iterator.next();
            iterator.remove();
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(CacheKey key, String preparedName) {
        Map<CacheKey, String> map = this.cache;
        synchronized (map) {
            this.cache.put(key, preparedName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCacheSize() {
        Map<CacheKey, String> map = this.cache;
        synchronized (map) {
            return this.cache.size();
        }
    }

    public String toString() {
        return "LimitedStatementCache{cache=" + this.cache + ", counter=" + this.counter + ", client=" + this.client + ", limit=" + this.limit + '}';
    }

    static class CacheKey {
        String sql;
        int[] parameterTypes;

        public CacheKey(String sql, int[] parameterTypes) {
            this.sql = sql;
            this.parameterTypes = parameterTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.sql != null ? !this.sql.equals(cacheKey.sql) : cacheKey.sql != null) {
                return false;
            }
            return Arrays.equals(this.parameterTypes, cacheKey.parameterTypes);
        }

        public int hashCode() {
            int result = this.sql != null ? this.sql.hashCode() : 0;
            result = 31 * result + Arrays.hashCode(this.parameterTypes);
            return result;
        }
    }
}

