/*
 * Decompiled with CFR 0.152.
 */
package play.libs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.ByteStringBuilder;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XML {
    public static Document fromString(String string) {
        return XML.fromInputStream(new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8)), "utf-8");
    }

    public static Document fromInputStream(InputStream inputStream, String string) {
        InputSource inputSource = new InputSource(inputStream);
        if (string != null) {
            inputSource.setEncoding(string);
        }
        return XML.fromInputSource(inputSource);
    }

    public static Document fromInputSource(InputSource inputSource) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            document.setXmlStandalone(true);
            return document;
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static ByteString toBytes(Document document) {
        ByteStringBuilder byteStringBuilder = ByteString$.MODULE$.newBuilder();
        try {
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(document), new StreamResult(byteStringBuilder.asOutputStream()));
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException);
        }
        return byteStringBuilder.result();
    }

    public static final class Constants {
        public static final String SAX_FEATURE_PREFIX = "http://xml.org/sax/features/";
        public static final String XERCES_FEATURE_PREFIX = "http://apache.org/xml/features/";
        public static final String EXTERNAL_GENERAL_ENTITIES_FEATURE = "external-general-entities";
        public static final String EXTERNAL_PARAMETER_ENTITIES_FEATURE = "external-parameter-entities";
        public static final String DISALLOW_DOCTYPE_DECL_FEATURE = "disallow-doctype-decl";
    }
}

