/*
 * Decompiled with CFR 0.152.
 */
package play.core.server.common;

import java.io.Serializable;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.util.ByteString$;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.http.DefaultHttpErrorHandler$;
import play.api.http.HeaderNames$;
import play.api.http.HttpEntity;
import play.api.http.HttpErrorHandler;
import play.api.http.HttpProtocol$;
import play.api.http.Status$;
import play.api.libs.typedmap.TypedMap;
import play.api.mvc.CookieBaker;
import play.api.mvc.CookieHeaderEncoding;
import play.api.mvc.Flash;
import play.api.mvc.FlashCookieBaker;
import play.api.mvc.RequestHeader;
import play.api.mvc.ResponseHeader;
import play.api.mvc.Result;
import play.api.mvc.SessionCookieBaker;
import play.api.mvc.request.Cell;
import play.api.mvc.request.RequestAttrKey$;
import play.core.Execution;
import play.core.server.common.InvalidHeaderCharacterException;
import play.core.server.common.ServerResultException;
import play.core.server.common.ServerResultUtils$DefaultClose$;
import play.core.server.common.ServerResultUtils$DefaultKeepAlive$;
import play.core.server.common.ServerResultUtils$SendClose$;
import play.core.server.common.ServerResultUtils$SendKeepAlive$;
import play.core.utils.AsciiBitSet;
import play.core.utils.AsciiRange;
import play.core.utils.AsciiSet;
import play.core.utils.AsciiSet$;
import play.core.utils.AsciiUnion;
import scala.Char$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public final class ServerResultUtils {
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(ServerResultUtils.class.getDeclaredField("DefaultKeepAlive$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(ServerResultUtils.class.getDeclaredField("DefaultClose$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(ServerResultUtils.class.getDeclaredField("SendClose$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ServerResultUtils.class.getDeclaredField("SendKeepAlive$lzy1"));
    private final SessionCookieBaker sessionBaker;
    private final FlashCookieBaker flashBaker;
    private final CookieHeaderEncoding cookieHeaderEncoding;
    private final Logger logger;
    private final AsciiBitSet allowedHeaderNameChars;
    private final AsciiBitSet allowedHeaderValueChars;
    private volatile Object SendKeepAlive$lzy1;
    private volatile Object SendClose$lzy1;
    private volatile Object DefaultClose$lzy1;
    private volatile Object DefaultKeepAlive$lzy1;
    public final String play$core$server$common$ServerResultUtils$$KEEP_ALIVE;
    public final String play$core$server$common$ServerResultUtils$$CLOSE;

    public ServerResultUtils(SessionCookieBaker sessionBaker, FlashCookieBaker flashBaker, CookieHeaderEncoding cookieHeaderEncoding) {
        this.sessionBaker = sessionBaker;
        this.flashBaker = flashBaker;
        this.cookieHeaderEncoding = cookieHeaderEncoding;
        this.logger = Logger$.MODULE$.apply(this.getClass());
        AsciiUnion TChar = AsciiSet$.MODULE$.apply('!', (Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'#', '$', '%', '&', '\'', '*', '+', '-', '.', '^', '_', '`', '|', '~'})).$bar$bar$bar(AsciiSet.Sets$.MODULE$.Digit()).$bar$bar$bar(AsciiSet.Sets$.MODULE$.Alpha());
        this.allowedHeaderNameChars = TChar.toBitSet();
        AsciiRange ObsText = new AsciiRange(128, 255);
        AsciiUnion FieldVChar = AsciiSet.Sets$.MODULE$.VChar().$bar$bar$bar((AsciiSet)ObsText);
        AsciiUnion FieldContent = FieldVChar.$bar$bar$bar(AsciiSet$.MODULE$.apply(' ', (Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'\t'})));
        this.allowedHeaderValueChars = FieldContent.toBitSet();
        this.play$core$server$common$ServerResultUtils$$KEEP_ALIVE = "keep-alive";
        this.play$core$server$common$ServerResultUtils$$CLOSE = "close";
    }

    public ConnectionHeader determineConnectionHeader(RequestHeader request, Result result) {
        String string = request.version();
        String string2 = HttpProtocol$.MODULE$.HTTP_1_1();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            if (result.header().headers().get((Object)HeaderNames$.MODULE$.CONNECTION()).exists((Function1 & Serializable)_$1 -> _$1.equalsIgnoreCase(this.play$core$server$common$ServerResultUtils$$CLOSE))) {
                return this.DefaultClose();
            }
            return (ConnectionHeader)(result.body() instanceof HttpEntity.Streamed && result.body().contentLength().isEmpty() || request.headers().get(HeaderNames$.MODULE$.CONNECTION()).exists((Function1 & Serializable)_$2 -> _$2.equalsIgnoreCase(this.play$core$server$common$ServerResultUtils$$CLOSE)) ? this.SendClose() : this.DefaultKeepAlive());
        }
        if (result.header().headers().get((Object)HeaderNames$.MODULE$.CONNECTION()).exists((Function1 & Serializable)_$3 -> _$3.equalsIgnoreCase(this.play$core$server$common$ServerResultUtils$$CLOSE))) {
            return this.DefaultClose();
        }
        return (ConnectionHeader)(result.body() instanceof HttpEntity.Streamed && result.body().contentLength().isEmpty() || request.headers().get(HeaderNames$.MODULE$.CONNECTION()).forall((Function1 & Serializable)_$4 -> !_$4.equalsIgnoreCase(this.play$core$server$common$ServerResultUtils$$KEEP_ALIVE)) ? this.DefaultClose() : this.SendKeepAlive());
    }

    public Future<Result> validateResult(RequestHeader request, Result result, HttpErrorHandler httpErrorHandler, Materializer mat) {
        String string = request.version();
        String string2 = HttpProtocol$.MODULE$.HTTP_1_0();
        if (!(string != null ? !string.equals(string2) : string2 != null) && result.body() instanceof HttpEntity.Chunked) {
            this.cancelEntity(result.body(), mat);
            ServerResultException exception = new ServerResultException("HTTP 1.0 client does not support chunked response", result, null);
            Future errorResult = httpErrorHandler.onServerError(request, (Throwable)exception);
            return errorResult.map((Function1 & Serializable)originalErrorResult -> {
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.CONNECTION());
                ResponseHeader newHeader = originalErrorResult.header().copy(Status$.MODULE$.HTTP_VERSION_NOT_SUPPORTED(), (Map)originalErrorResult.header().headers().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.play$core$server$common$ServerResultUtils$$CLOSE)), originalErrorResult.header().copy$default$3());
                return originalErrorResult.copy(newHeader, originalErrorResult.copy$default$2(), originalErrorResult.copy$default$3(), originalErrorResult.copy$default$4(), originalErrorResult.copy$default$5(), originalErrorResult.copy$default$6());
            }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
        }
        if (!this.mayHaveEntity(result.header().status()) && !result.body().isKnownEmpty()) {
            this.cancelEntity(result.body(), mat);
            HttpEntity.Strict strict = HttpEntity.Strict$.MODULE$.apply(ByteString$.MODULE$.empty(), result.body().contentType());
            ResponseHeader responseHeader = result.copy$default$1();
            Option option = result.copy$default$3();
            Option option2 = result.copy$default$4();
            Seq seq = result.copy$default$5();
            TypedMap typedMap = result.copy$default$6();
            return Future$.MODULE$.successful((Object)result.copy(responseHeader, (HttpEntity)strict, option, option2, seq, typedMap));
        }
        return Future$.MODULE$.successful((Object)result);
    }

    public void validateHeaderNameChars(String headerName) {
        this.validateString(this.allowedHeaderNameChars, "header name", headerName);
    }

    public void validateHeaderValueChars(String headerValue) {
        this.validateString(this.allowedHeaderValueChars, "header value", headerValue);
    }

    private void validateString(AsciiBitSet allowedSet, String setDescription, String string) {
        ServerResultUtils.loop$1(string, allowedSet, setDescription, 0);
    }

    public <R> Future<R> resultConversionWithErrorHandling(RequestHeader requestHeader, Result result, HttpErrorHandler errorHandler, Function1<Result, Future<R>> resultConverter, Function0<R> fallbackResponse) {
        Future future;
        try {
            future = ((Future)resultConverter.apply((Object)result)).recoverWith((PartialFunction)new Serializable(result, errorHandler, requestHeader, resultConverter, fallbackResponse, this){
                private final Result result$2;
                private final HttpErrorHandler errorHandler$2;
                private final RequestHeader requestHeader$3;
                private final Function1 resultConverter$3;
                private final Function0 fallbackResponse$3;
                private final /* synthetic */ ServerResultUtils $outer;
                {
                    this.result$2 = result$3;
                    this.errorHandler$2 = errorHandler$3;
                    this.requestHeader$3 = requestHeader$4;
                    this.resultConverter$3 = resultConverter$4;
                    this.fallbackResponse$3 = fallbackResponse$4;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable;
                    Throwable t = throwable = x;
                    return true;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable;
                    Throwable t = throwable = x;
                    return this.$outer.play$core$server$common$ServerResultUtils$$_$handleConversionError$1(this.result$2, this.errorHandler$2, this.requestHeader$3, this.resultConverter$3, this.fallbackResponse$3, t);
                }
            }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                future = this.play$core$server$common$ServerResultUtils$$_$handleConversionError$1(result, errorHandler, requestHeader, resultConverter, fallbackResponse, e);
            }
            throw throwable;
        }
        return future;
    }

    public boolean mayHaveEntity(int status) {
        int n = status;
        return Status$.MODULE$.CONTINUE() != n && Status$.MODULE$.SWITCHING_PROTOCOLS() != n && Status$.MODULE$.NO_CONTENT() != n && Status$.MODULE$.NOT_MODIFIED() != n;
        {
        }
    }

    public Object cancelEntity(HttpEntity entity, Materializer mat) {
        HttpEntity httpEntity = entity;
        if (httpEntity instanceof HttpEntity.Chunked) {
            HttpEntity.Chunked chunked = HttpEntity.Chunked$.MODULE$.unapply((HttpEntity.Chunked)httpEntity);
            Source source = chunked._1();
            Option option = chunked._2();
            Source chunks = source;
            return chunks.runWith((Graph)Sink$.MODULE$.cancelled(), mat);
        }
        if (httpEntity instanceof HttpEntity.Streamed) {
            HttpEntity.Streamed streamed = HttpEntity.Streamed$.MODULE$.unapply((HttpEntity.Streamed)httpEntity);
            Source source = streamed._1();
            Option option = streamed._2();
            Option option2 = streamed._3();
            Source data = source;
            return data.runWith((Graph)Sink$.MODULE$.cancelled(), mat);
        }
        return BoxedUnit.UNIT;
    }

    public final ServerResultUtils$SendKeepAlive$ SendKeepAlive() {
        Object object = this.SendKeepAlive$lzy1;
        if (object instanceof ServerResultUtils$SendKeepAlive$) {
            return (ServerResultUtils$SendKeepAlive$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ServerResultUtils$SendKeepAlive$)this.SendKeepAlive$lzyINIT1();
    }

    private Object SendKeepAlive$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.SendKeepAlive$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ServerResultUtils$SendKeepAlive$ serverResultUtils$SendKeepAlive$ = null;
                    try {
                        serverResultUtils$SendKeepAlive$ = new ServerResultUtils$SendKeepAlive$(this);
                        object2 = serverResultUtils$SendKeepAlive$ == null ? LazyVals.NullValue$.MODULE$ : serverResultUtils$SendKeepAlive$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.SendKeepAlive$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return serverResultUtils$SendKeepAlive$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final ServerResultUtils$SendClose$ SendClose() {
        Object object = this.SendClose$lzy1;
        if (object instanceof ServerResultUtils$SendClose$) {
            return (ServerResultUtils$SendClose$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ServerResultUtils$SendClose$)this.SendClose$lzyINIT1();
    }

    private Object SendClose$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.SendClose$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ServerResultUtils$SendClose$ serverResultUtils$SendClose$ = null;
                    try {
                        serverResultUtils$SendClose$ = new ServerResultUtils$SendClose$(this);
                        object2 = serverResultUtils$SendClose$ == null ? LazyVals.NullValue$.MODULE$ : serverResultUtils$SendClose$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.SendClose$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return serverResultUtils$SendClose$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final ServerResultUtils$DefaultClose$ DefaultClose() {
        Object object = this.DefaultClose$lzy1;
        if (object instanceof ServerResultUtils$DefaultClose$) {
            return (ServerResultUtils$DefaultClose$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ServerResultUtils$DefaultClose$)this.DefaultClose$lzyINIT1();
    }

    private Object DefaultClose$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.DefaultClose$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ServerResultUtils$DefaultClose$ serverResultUtils$DefaultClose$ = null;
                    try {
                        serverResultUtils$DefaultClose$ = new ServerResultUtils$DefaultClose$();
                        object2 = serverResultUtils$DefaultClose$ == null ? LazyVals.NullValue$.MODULE$ : serverResultUtils$DefaultClose$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.DefaultClose$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return serverResultUtils$DefaultClose$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final ServerResultUtils$DefaultKeepAlive$ DefaultKeepAlive() {
        Object object = this.DefaultKeepAlive$lzy1;
        if (object instanceof ServerResultUtils$DefaultKeepAlive$) {
            return (ServerResultUtils$DefaultKeepAlive$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ServerResultUtils$DefaultKeepAlive$)this.DefaultKeepAlive$lzyINIT1();
    }

    private Object DefaultKeepAlive$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.DefaultKeepAlive$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ServerResultUtils$DefaultKeepAlive$ serverResultUtils$DefaultKeepAlive$ = null;
                    try {
                        serverResultUtils$DefaultKeepAlive$ = new ServerResultUtils$DefaultKeepAlive$();
                        object2 = serverResultUtils$DefaultKeepAlive$ == null ? LazyVals.NullValue$.MODULE$ : serverResultUtils$DefaultKeepAlive$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.DefaultKeepAlive$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return serverResultUtils$DefaultKeepAlive$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Result prepareCookies(RequestHeader requestHeader, Result result) {
        boolean bl;
        Option option = requestHeader.attrs().get(RequestAttrKey$.MODULE$.Flash());
        if (None$.MODULE$.equals(option)) {
            bl = false;
        } else if (option instanceof Some) {
            Cell flashCell = (Cell)((Some)option).value();
            bl = !((Flash)flashCell.value()).isEmpty();
        } else {
            throw new MatchError((Object)option);
        }
        boolean requestHasFlash = bl;
        return result.bakeCookies(this.cookieHeaderEncoding, (CookieBaker)this.sessionBaker, (CookieBaker)this.flashBaker, requestHasFlash);
    }

    public Iterable<Tuple2<String, String>> splitSetCookieHeaders(Map<String, String> headers) {
        if (headers.contains((Object)HeaderNames$.MODULE$.SET_COOKIE())) {
            return (Iterable)headers.toSeq().flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String string = (String)tuple2._1();
                    String string2 = (String)tuple2._2();
                    String string3 = HeaderNames$.MODULE$.SET_COOKIE();
                    String string4 = string;
                    if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                        String value = string2;
                        return (Seq)this.splitSetCookieHeaderValue(value).map((Function1 & Serializable)cookiePart -> {
                            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.SET_COOKIE());
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, cookiePart);
                        });
                    }
                    String name = string;
                    String value = string2;
                    return (Seq)((SeqOps)new .colon.colon((Object)Tuple2$.MODULE$.apply((Object)name, (Object)value), (List)Nil$.MODULE$));
                }
                throw new MatchError((Object)tuple2);
            });
        }
        return headers;
    }

    public Seq<String> splitSetCookieHeaderValue(String value) {
        return ArraySeq$.MODULE$.unsafeWrapArray((Object)this.cookieHeaderEncoding.SetCookieHeaderSeparatorRegex().split((CharSequence)value));
    }

    private static final void loop$1(String string$1, AsciiBitSet allowedSet$1, String setDescription$1, int i) {
        while (i < string$1.length()) {
            char c = string$1.charAt(i);
            if (!allowedSet$1.get(Char$.MODULE$.char2int(c))) {
                throw new InvalidHeaderCharacterException("Invalid " + setDescription$1 + " character: '" + c + "' (" + c + ") in string " + string$1 + " at position " + i, c);
            }
            ++i;
        }
    }

    private static final String log$1$$anonfun$1(String message$1) {
        return message$1;
    }

    private static final Throwable log$1$$anonfun$2(Throwable error$1) {
        return error$1;
    }

    private static final String log$1$$anonfun$3(String message$2) {
        return message$2;
    }

    private static final Throwable log$1$$anonfun$4(Throwable error$2) {
        return error$2;
    }

    private final void log$1(boolean isInvalidHeaderCharacter$1, String message, Throwable error) {
        if (isInvalidHeaderCharacter$1) {
            this.logger.info(() -> ServerResultUtils.log$1$$anonfun$1(message), () -> ServerResultUtils.log$1$$anonfun$2(error), MarkerContext$.MODULE$.NoMarker());
            return;
        }
        this.logger.error(() -> ServerResultUtils.log$1$$anonfun$3(message), () -> ServerResultUtils.log$1$$anonfun$4(error), MarkerContext$.MODULE$.NoMarker());
    }

    private static final String handleConversionError$1$$anonfun$2() {
        return "Error occurred during error handling. Original error: ";
    }

    private static final Throwable handleConversionError$1$$anonfun$3(Throwable conversionError$1) {
        return conversionError$1;
    }

    private static final String handleConversionError$1$$anonfun$4() {
        return "Error occurred during error handling. Error handling error: ";
    }

    private static final Throwable handleConversionError$1$$anonfun$5(Throwable onErrorError$1) {
        return onErrorError$1;
    }

    public final Future play$core$server$common$ServerResultUtils$$_$handleConversionError$1(Result result$1, HttpErrorHandler errorHandler$1, RequestHeader requestHeader$1, Function1 resultConverter$1, Function0 fallbackResponse$1, Throwable conversionError) {
        Future future;
        boolean isInvalidHeaderCharacter = conversionError instanceof InvalidHeaderCharacterException;
        boolean shouldLog = isInvalidHeaderCharacter ? this.logger.isInfoEnabled(MarkerContext$.MODULE$.NoMarker()) : this.logger.isErrorEnabled(MarkerContext$.MODULE$.NoMarker());
        try {
            if (shouldLog) {
                String prettyHeaders = ((IterableOnceOps)result$1.header().headers().map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        String value = (String)tuple2._2();
                        return "<" + name + ">: <" + value + ">";
                    }
                    throw new MatchError((Object)tuple2);
                })).mkString("[", ", ", "]");
                String msg = "Exception occurred while converting Result with headers " + prettyHeaders + ". Calling HttpErrorHandler to get alternative Result.";
                this.log$1(isInvalidHeaderCharacter, msg, conversionError);
            }
            Future futureErrorResult = isInvalidHeaderCharacter ? errorHandler$1.onClientError(requestHeader$1, 400, "Invalid header: " + conversionError.getMessage()) : errorHandler$1.onServerError(requestHeader$1, (Throwable)new ServerResultException("Error converting Play Result for server backend", result$1, conversionError));
            future = futureErrorResult.flatMap((Function1 & Serializable)errorResult -> this.resultConversionWithErrorHandling(requestHeader$1, (Result)errorResult, (HttpErrorHandler)DefaultHttpErrorHandler$.MODULE$, (Function1)resultConverter$1, (Function0)fallbackResponse$1), (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable onErrorError = throwable3 = (Throwable)option.get();
                this.logger.error(ServerResultUtils::handleConversionError$1$$anonfun$2, () -> ServerResultUtils.handleConversionError$1$$anonfun$3(conversionError), MarkerContext$.MODULE$.NoMarker());
                this.logger.error(ServerResultUtils::handleConversionError$1$$anonfun$4, () -> ServerResultUtils.handleConversionError$1$$anonfun$5(onErrorError), MarkerContext$.MODULE$.NoMarker());
                future = Future$.MODULE$.successful(fallbackResponse$1.apply());
            }
            throw throwable;
        }
        return future;
    }

    public interface ConnectionHeader {
        public boolean willClose();

        public Option<String> header();
    }
}

