/*
 * Decompiled with CFR 0.152.
 */
package play.core.server.ssl;

import com.typesafe.config.Config;
import com.typesafe.sslconfig.ssl.FakeKeyStore;
import com.typesafe.sslconfig.util.NoopLogger$;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import play.api.MarkerContext$;
import play.core.ApplicationProvider;
import play.core.server.ServerConfig;
import play.core.server.ssl.DefaultSSLEngineProvider$;
import play.core.server.ssl.noCATrustManager$;
import play.server.api.SSLEngineProvider;
import play.utils.PlayIO$;
import scala.Option;
import scala.util.control.NonFatal$;

public class DefaultSSLEngineProvider
implements SSLEngineProvider {
    private final ServerConfig serverConfig;
    private final SSLContext sslContext;

    public DefaultSSLEngineProvider(ServerConfig serverConfig, ApplicationProvider appProvider) {
        this.serverConfig = serverConfig;
        this.sslContext = this.createSSLContext(appProvider);
    }

    public SSLContext sslContext() {
        return this.sslContext;
    }

    public SSLEngine createSSLEngine() {
        return this.sslContext().createSSLEngine();
    }

    private SSLContext createSSLContext(ApplicationProvider applicationProvider) {
        TrustManager[] trustManagerArray;
        KeyManagerFactory keyManagerFactory;
        Config httpsConfig;
        block10: {
            httpsConfig = this.serverConfig.configuration().underlying().getConfig("play.server.https");
            Config keyStoreConfig = httpsConfig.getConfig("keyStore");
            if (keyStoreConfig.hasPath("path")) {
                String path = keyStoreConfig.getString("path");
                KeyStore keyStore = KeyStore.getInstance(keyStoreConfig.getString("type"));
                char[] password = keyStoreConfig.getString("password").toCharArray();
                String algorithm = keyStoreConfig.hasPath("algorithm") ? keyStoreConfig.getString("algorithm") : KeyManagerFactory.getDefaultAlgorithm();
                File file = new File(path);
                if (file.isFile()) {
                    InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
                    try {
                        try {
                            keyStore.load(in, password);
                            DefaultSSLEngineProvider$.play$core$server$ssl$DefaultSSLEngineProvider$$$logger.debug(() -> DefaultSSLEngineProvider.$anonfun$1(file), MarkerContext$.MODULE$.NoMarker());
                            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
                            kmf.init(keyStore, password);
                            keyManagerFactory = kmf;
                            break block10;
                        }
                        catch (Throwable throwable) {
                            Option option;
                            Throwable throwable2 = throwable;
                            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                Throwable throwable3;
                                Throwable e = throwable3 = (Throwable)option.get();
                                throw new Exception("Error loading HTTPS keystore from " + file.getAbsolutePath(), e);
                            }
                            throw throwable;
                        }
                    }
                    finally {
                        PlayIO$.MODULE$.closeQuietly((Closeable)in);
                    }
                }
                throw new Exception("Unable to find HTTPS keystore at \"" + file.getAbsolutePath() + "\"");
            }
            DefaultSSLEngineProvider$.play$core$server$ssl$DefaultSSLEngineProvider$$$logger.warn(DefaultSSLEngineProvider::$anonfun$2, MarkerContext$.MODULE$.NoMarker());
            FakeKeyStore FakeKeyStore2 = new FakeKeyStore(NoopLogger$.MODULE$.factory());
            keyManagerFactory = FakeKeyStore2.keyManagerFactory(this.serverConfig.rootDir());
        }
        KeyManagerFactory keyManagerFactory2 = keyManagerFactory;
        Config trustStoreConfig = httpsConfig.getConfig("trustStore");
        if (trustStoreConfig.getBoolean("noCaVerification")) {
            DefaultSSLEngineProvider$.play$core$server$ssl$DefaultSSLEngineProvider$$$logger.warn(DefaultSSLEngineProvider::$anonfun$3, MarkerContext$.MODULE$.NoMarker());
            trustManagerArray = new TrustManager[]{noCATrustManager$.MODULE$};
        } else {
            DefaultSSLEngineProvider$.play$core$server$ssl$DefaultSSLEngineProvider$$$logger.debug(DefaultSSLEngineProvider::$anonfun$4, MarkerContext$.MODULE$.NoMarker());
            trustManagerArray = null;
        }
        TrustManager[] tm = trustManagerArray;
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagerFactory2.getKeyManagers(), tm, null);
        return sslContext;
    }

    private static final String $anonfun$1(File file$1) {
        return "Using HTTPS keystore at " + file$1.getAbsolutePath();
    }

    private static final String $anonfun$2() {
        return "Using generated key with self signed certificate for HTTPS. This should NOT be used in production.";
    }

    private static final String $anonfun$3() {
        return "HTTPS configured with no client side CA verification. Requires http://webid.info/ for client certificate verification.";
    }

    private static final String $anonfun$4() {
        return "Using default trust store for client side CA verification";
    }
}

