/*
 * Decompiled with CFR 0.152.
 */
package play.core.server.common;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import play.api.Application;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.http.HttpConfiguration;
import play.api.http.HttpConfiguration$;
import play.api.libs.crypto.CookieSigner;
import play.api.libs.crypto.CookieSignerProvider;
import play.api.mvc.CookieHeaderEncoding;
import play.api.mvc.DefaultCookieHeaderEncoding;
import play.api.mvc.DefaultFlashCookieBaker;
import play.api.mvc.DefaultSessionCookieBaker;
import play.api.mvc.FlashCookieBaker;
import play.api.mvc.SessionCookieBaker;
import play.api.mvc.request.DefaultRequestFactory;
import play.api.mvc.request.RequestFactory;
import play.core.server.ServerProvider;
import play.core.server.common.ForwardedHeaderHandler;
import play.core.server.common.ForwardedHeaderHandler$ForwardedHeaderHandlerConfig$;
import play.core.server.common.ServerDebugInfo;
import play.core.server.common.ServerDebugInfo$;
import play.core.server.common.ServerResultUtils;
import play.utils.InlineCache;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public abstract class ReloadCache<T> {
    private final AtomicInteger reloadCounter = new AtomicInteger(0);
    private final Function1<Try<Application>, T> reloadCache = new InlineCache((Function1 & Serializable)tryApp -> {
        this.reloadCounter.incrementAndGet();
        return this.reloadValue((Try<Application>)tryApp);
    });

    public final int reloadCount() {
        return this.reloadCounter.get();
    }

    public final T cachedFrom(Try<Application> tryApp) {
        return (T)this.reloadCache.apply(tryApp);
    }

    public abstract T reloadValue(Try<Application> var1);

    public final Option<ServerDebugInfo> reloadDebugInfo(Try<Application> tryApp, ServerProvider serverProvider) {
        boolean bl;
        Try<Application> try_ = tryApp;
        if (try_ instanceof Success) {
            Application app = (Application)((Success)try_).value();
            bl = BoxesRunTime.unboxToBoolean((Object)app.configuration().get("play.server.debug.addDebugInfoToRequests", ConfigLoader$.MODULE$.booleanLoader()));
        } else if (try_ instanceof Failure) {
            bl = true;
        } else {
            throw new MatchError(try_);
        }
        boolean enabled = bl;
        if (enabled) {
            return Some$.MODULE$.apply((Object)ServerDebugInfo$.MODULE$.apply(serverProvider, this.reloadCount()));
        }
        return None$.MODULE$;
    }

    public final ServerResultUtils reloadServerResultUtils(Try<Application> tryApp) {
        Tuple3 tuple3;
        Try<Application> try_ = tryApp;
        if (try_ instanceof Success) {
            DefaultRequestFactory drf;
            Application app = (Application)((Success)try_).value();
            RequestFactory requestFactory = app.requestFactory();
            DefaultRequestFactory requestFactory2 = requestFactory instanceof DefaultRequestFactory ? (drf = (DefaultRequestFactory)requestFactory) : new DefaultRequestFactory(app.httpConfiguration());
            tuple3 = Tuple3$.MODULE$.apply((Object)requestFactory2.sessionBaker(), (Object)requestFactory2.flashBaker(), (Object)requestFactory2.cookieHeaderEncoding());
        } else if (try_ instanceof Failure) {
            HttpConfiguration httpConfig = HttpConfiguration$.MODULE$.apply(HttpConfiguration$.MODULE$.$lessinit$greater$default$1(), HttpConfiguration$.MODULE$.$lessinit$greater$default$2(), HttpConfiguration$.MODULE$.$lessinit$greater$default$3(), HttpConfiguration$.MODULE$.$lessinit$greater$default$4(), HttpConfiguration$.MODULE$.$lessinit$greater$default$5(), HttpConfiguration$.MODULE$.$lessinit$greater$default$6(), HttpConfiguration$.MODULE$.$lessinit$greater$default$7(), HttpConfiguration$.MODULE$.$lessinit$greater$default$8());
            CookieSigner cookieSigner = new CookieSignerProvider(httpConfig.secret()).get();
            tuple3 = Tuple3$.MODULE$.apply((Object)new DefaultSessionCookieBaker(httpConfig.session(), httpConfig.secret(), cookieSigner), (Object)new DefaultFlashCookieBaker(httpConfig.flash(), httpConfig.secret(), cookieSigner), (Object)new DefaultCookieHeaderEncoding(httpConfig.cookies()));
        } else {
            throw new MatchError(try_);
        }
        Tuple3 tuple32 = tuple3;
        SessionCookieBaker sessionBaker = (SessionCookieBaker)tuple32._1();
        FlashCookieBaker flashBaker = (FlashCookieBaker)tuple32._2();
        CookieHeaderEncoding cookieHeaderEncoding = (CookieHeaderEncoding)tuple32._3();
        return new ServerResultUtils(sessionBaker, flashBaker, cookieHeaderEncoding);
    }

    public final ForwardedHeaderHandler reloadForwardedHeaderHandler(Try<Application> tryApp) {
        ForwardedHeaderHandler.ForwardedHeaderHandlerConfig forwardedHeaderConfiguration = ForwardedHeaderHandler$ForwardedHeaderHandlerConfig$.MODULE$.apply((Option<Configuration>)tryApp.toOption().map((Function1 & Serializable)_$1 -> _$1.configuration()));
        return new ForwardedHeaderHandler(forwardedHeaderConfiguration);
    }
}

