/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.json;

import java.io.Serializable;
import java.math.BigDecimal;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess$;
import play.api.libs.json.JsonConfig;
import play.api.libs.json.JsonValidationError$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class BigDecimalParser$
implements Serializable {
    public static final BigDecimalParser$ MODULE$ = new BigDecimalParser$();

    private BigDecimalParser$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BigDecimalParser$.class);
    }

    public JsResult<BigDecimal> parse(String input, JsonConfig jsonConfig) {
        JsResult<Nothing$> jsResult;
        if (input.length() > jsonConfig.bigDecimalParseConfig().digitsLimit()) {
            return JsError$.MODULE$.apply("error.expected.numberdigitlimit");
        }
        try {
            BigDecimal bigDecimal = new BigDecimal(input, jsonConfig.bigDecimalParseConfig().mathContext());
            int scale = bigDecimal.scale();
            jsResult = Math.abs(scale) > jsonConfig.bigDecimalParseConfig().scaleLimit() ? JsError$.MODULE$.apply(JsonValidationError$.MODULE$.apply("error.expected.numberscalelimit", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)scale)}))) : JsSuccess$.MODULE$.apply(bigDecimal, JsSuccess$.MODULE$.$lessinit$greater$default$2());
        }
        catch (NumberFormatException numberFormatException) {
            jsResult = JsError$.MODULE$.apply("error.expected.numberformatexception");
        }
        return jsResult;
    }
}

