/*
 * Decompiled with CFR 0.152.
 */
package play.routing;

import jakarta.inject.Inject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.jodah.typetools.TypeResolver;
import play.BuiltInComponents;
import play.api.mvc.BodyParser;
import play.api.mvc.PathBindable;
import play.api.mvc.PathBindable$;
import play.core.j.JavaContextComponents;
import play.core.routing.HandlerInvokerFactory$;
import play.libs.Scala;
import play.mvc.BodyParser;
import play.mvc.Http;
import play.mvc.PathBindable;
import play.mvc.Result;
import play.routing.RequestFunctions;
import play.routing.Router;
import play.routing.RouterBuilderHelper;
import scala.Option;
import scala.reflect.ClassTag$;

public class RoutingDsl {
    private final BodyParser<Http.RequestBody> bodyParser;
    final List<Route> routes = new ArrayList<Route>();
    private static final Pattern paramExtractor = Pattern.compile("([:*$])(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)(?:<(.*)>)?");

    @Inject
    public RoutingDsl(BodyParser.Default default_) {
        this.bodyParser = HandlerInvokerFactory$.MODULE$.javaBodyParserToScala((play.mvc.BodyParser)default_);
    }

    @Deprecated
    public RoutingDsl(BodyParser.Default default_, JavaContextComponents javaContextComponents) {
        this(default_);
    }

    public static RoutingDsl fromComponents(BuiltInComponents builtInComponents) {
        return new RoutingDsl(builtInComponents.defaultBodyParser());
    }

    public PathPatternMatcher GET(String string) {
        return new PathPatternMatcher("GET", string);
    }

    public PathPatternMatcher HEAD(String string) {
        return new PathPatternMatcher("HEAD", string);
    }

    public PathPatternMatcher POST(String string) {
        return new PathPatternMatcher("POST", string);
    }

    public PathPatternMatcher PUT(String string) {
        return new PathPatternMatcher("PUT", string);
    }

    public PathPatternMatcher DELETE(String string) {
        return new PathPatternMatcher("DELETE", string);
    }

    public PathPatternMatcher PATCH(String string) {
        return new PathPatternMatcher("PATCH", string);
    }

    public PathPatternMatcher OPTIONS(String string) {
        return new PathPatternMatcher("OPTIONS", string);
    }

    public PathPatternMatcher match(String string, String string2) {
        return new PathPatternMatcher(string, string2);
    }

    public Router build() {
        return new RouterBuilderHelper(this.bodyParser).build(this);
    }

    private RoutingDsl with(String string, String string2, int n, Object object, Class<?> clazz) {
        Object object222;
        final Matcher matcher = paramExtractor.matcher(string2);
        List list = StreamSupport.stream(new Spliterators.AbstractSpliterator<MatchResult>((long)n, 0){

            @Override
            public boolean tryAdvance(Consumer<? super MatchResult> consumer) {
                if (matcher.find()) {
                    consumer.accept(matcher.toMatchResult());
                    return true;
                }
                return false;
            }
        }, false).collect(Collectors.toList());
        if (list.size() != n) {
            throw new IllegalArgumentException("Path contains " + list.size() + " params but function of arity " + n + " was passed");
        }
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<RouteParam> arrayList = new ArrayList<RouteParam>(n);
        Iterator<Class> iterator = Arrays.asList(TypeResolver.resolveRawArguments(clazz, object.getClass())).iterator();
        int n2 = 0;
        for (Object object222 : list) {
            stringBuilder.append(Pattern.quote(string2.substring(n2, object222.start())));
            String string3 = object222.group(1);
            String string4 = object222.group(2);
            play.api.mvc.PathBindable<?> pathBindable = this.pathBindableFor(iterator.next());
            switch (string3) {
                case ":": {
                    stringBuilder.append("([^/]+)");
                    arrayList.add(new RouteParam(string4, true, pathBindable));
                    break;
                }
                case "*": {
                    stringBuilder.append("(.*)");
                    arrayList.add(new RouteParam(string4, false, pathBindable));
                    break;
                }
                default: {
                    stringBuilder.append("(").append(object222.group(3)).append(")");
                    arrayList.add(new RouteParam(string4, false, pathBindable));
                }
            }
            n2 = object222.end();
        }
        stringBuilder.append(Pattern.quote(string2.substring(n2)));
        Pattern pattern = Pattern.compile(stringBuilder.toString());
        object222 = null;
        for (Method method : clazz.getMethods()) {
            if (!Modifier.isAbstract(method.getModifiers())) continue;
            object222 = method;
        }
        this.routes.add(new Route(string, pattern, arrayList, object, (Method)object222));
        return this;
    }

    private play.api.mvc.PathBindable<?> pathBindableFor(Class<?> clazz) {
        play.api.mvc.PathBindable pathBindable = (play.api.mvc.PathBindable)Scala.orNull((Option)PathBindable$.MODULE$.pathBindableRegister().get(clazz));
        if (pathBindable != null) {
            return pathBindable;
        }
        if (PathBindable.class.isAssignableFrom(clazz)) {
            return RoutingDsl.javaPathBindableFor(clazz);
        }
        if (clazz.equals(Object.class)) {
            return PathBindable.bindableString$.MODULE$;
        }
        throw new IllegalArgumentException("Don't know how to bind argument of type " + clazz);
    }

    private static <A extends PathBindable<A>> play.api.mvc.PathBindable<?> javaPathBindableFor(Class<?> clazz) {
        return PathBindable$.MODULE$.javaPathBindable(ClassTag$.MODULE$.apply(clazz));
    }

    public class PathPatternMatcher {
        private final String method;
        private final String pathPattern;

        public PathPatternMatcher(String string, String string2) {
            this.method = string;
            this.pathPattern = string2;
        }

        public RoutingDsl routingTo(RequestFunctions.Params0<Result> params0) {
            return this.build(0, params0, RequestFunctions.Params0.class);
        }

        public <P1> RoutingDsl routingTo(RequestFunctions.Params1<P1, Result> params1) {
            return this.build(1, params1, RequestFunctions.Params1.class);
        }

        public <P1, P2> RoutingDsl routingTo(RequestFunctions.Params2<P1, P2, Result> params2) {
            return this.build(2, params2, RequestFunctions.Params2.class);
        }

        public <P1, P2, P3> RoutingDsl routingTo(RequestFunctions.Params3<P1, P2, P3, Result> params3) {
            return this.build(3, params3, RequestFunctions.Params3.class);
        }

        public RoutingDsl routingAsync(RequestFunctions.Params0<? extends CompletionStage<Result>> params0) {
            return this.build(0, params0, RequestFunctions.Params0.class);
        }

        public <P1> RoutingDsl routingAsync(RequestFunctions.Params1<P1, ? extends CompletionStage<Result>> params1) {
            return this.build(1, params1, RequestFunctions.Params1.class);
        }

        public <P1, P2> RoutingDsl routingAsync(RequestFunctions.Params2<P1, P2, ? extends CompletionStage<Result>> params2) {
            return this.build(2, params2, RequestFunctions.Params2.class);
        }

        public <A1, A2, A3> RoutingDsl routingAsync(RequestFunctions.Params3<A1, A2, A3, ? extends CompletionStage<Result>> params3) {
            return this.build(3, params3, RequestFunctions.Params3.class);
        }

        private <T> RoutingDsl build(int n, T t, Class<T> clazz) {
            return RoutingDsl.this.with(this.method, this.pathPattern, n, t, clazz);
        }
    }

    static class RouteParam {
        final String name;
        final Boolean decode;
        final play.api.mvc.PathBindable<?> pathBindable;

        RouteParam(String string, Boolean bl, play.api.mvc.PathBindable<?> pathBindable) {
            this.name = string;
            this.decode = bl;
            this.pathBindable = pathBindable;
        }
    }

    static class Route {
        final String method;
        final Pattern pathPattern;
        final List<RouteParam> params;
        final Object action;
        final Method actionMethod;

        Route(String string, Pattern pattern, List<RouteParam> list, Object object, Method method) {
            this.method = string;
            this.pathPattern = pattern;
            this.params = list;
            this.action = object;
            this.actionMethod = method;
        }
    }
}

