/*
 * Decompiled with CFR 0.152.
 */
package play.db;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import play.api.Configuration;
import play.api.db.PooledDatabase;
import play.db.ConnectionCallable;
import play.db.ConnectionRunnable;
import play.db.Database;
import play.db.TransactionIsolationLevel;
import scala.runtime.AbstractFunction1;
import scala.runtime.BoxedUnit;

public class DefaultDatabase
implements Database {
    private final play.api.db.Database db;

    public DefaultDatabase(play.api.db.Database database) {
        this.db = database;
    }

    public DefaultDatabase(String string, Config config) {
        this((play.api.db.Database)new PooledDatabase(string, new Configuration(config.withFallback((ConfigMergeable)ConfigFactory.defaultReference().getConfig("play.db.prototype")))));
    }

    public DefaultDatabase(String string, Map<String, ? extends Object> map) {
        this((play.api.db.Database)new PooledDatabase(string, new Configuration(ConfigFactory.parseMap(map).withFallback((ConfigMergeable)ConfigFactory.defaultReference().getConfig("play.db.prototype")))));
    }

    public String getName() {
        return this.db.name();
    }

    public DataSource getDataSource() {
        return this.db.dataSource();
    }

    public String getUrl() {
        return this.db.url();
    }

    public Connection getConnection() {
        return this.db.getConnection();
    }

    public Connection getConnection(boolean bl) {
        return this.db.getConnection(bl);
    }

    public void withConnection(ConnectionRunnable connectionRunnable) {
        this.db.withConnection(this.connectionFunction(connectionRunnable));
    }

    public <A> A withConnection(ConnectionCallable<A> connectionCallable) {
        return (A)this.db.withConnection(this.connectionFunction(connectionCallable));
    }

    public void withConnection(boolean bl, ConnectionRunnable connectionRunnable) {
        this.db.withConnection(bl, this.connectionFunction(connectionRunnable));
    }

    public <A> A withConnection(boolean bl, ConnectionCallable<A> connectionCallable) {
        return (A)this.db.withConnection(bl, this.connectionFunction(connectionCallable));
    }

    public void withTransaction(ConnectionRunnable connectionRunnable) {
        this.db.withTransaction(this.connectionFunction(connectionRunnable));
    }

    public void withTransaction(TransactionIsolationLevel transactionIsolationLevel, ConnectionRunnable connectionRunnable) {
        this.db.withTransaction(transactionIsolationLevel.asScala(), this.connectionFunction(connectionRunnable));
    }

    public <A> A withTransaction(ConnectionCallable<A> connectionCallable) {
        return (A)this.db.withTransaction(this.connectionFunction(connectionCallable));
    }

    public <A> A withTransaction(TransactionIsolationLevel transactionIsolationLevel, ConnectionCallable<A> connectionCallable) {
        return (A)this.db.withTransaction(transactionIsolationLevel.asScala(), this.connectionFunction(connectionCallable));
    }

    public void shutdown() {
        this.db.shutdown();
    }

    AbstractFunction1<Connection, BoxedUnit> connectionFunction(final ConnectionRunnable connectionRunnable) {
        return new AbstractFunction1<Connection, BoxedUnit>(){

            public BoxedUnit apply(Connection connection) {
                try {
                    connectionRunnable.run(connection);
                    return BoxedUnit.UNIT;
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException("Connection runnable failed", sQLException);
                }
            }
        };
    }

    <A> AbstractFunction1<Connection, A> connectionFunction(final ConnectionCallable<A> connectionCallable) {
        return new AbstractFunction1<Connection, A>(){

            public A apply(Connection connection) {
                try {
                    return connectionCallable.call(connection);
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException("Connection callable failed", sQLException);
                }
            }
        };
    }
}

