/*
 * Decompiled with CFR 0.152.
 */
package play.api.cache;

import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import play.api.cache.SerializableResult$;
import play.api.http.HttpEntity;
import play.api.mvc.ResponseHeader$;
import play.api.mvc.Result;
import play.api.mvc.Result$;
import scala.Byte$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Builder;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.function.JProcedure1;

public final class SerializableResult
implements Externalizable {
    private Result cachedResult;

    public static byte encodingVersion() {
        return SerializableResult$.MODULE$.encodingVersion();
    }

    public SerializableResult(Result constructorResult) {
        if (!Option$.MODULE$.apply((Object)constructorResult).forall((Function1 & Serializable)_$1 -> _$1.body() instanceof HttpEntity.Strict)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"Only strict entities can be cached, streamed entities cannot be cached");
        }
        this.cachedResult = constructorResult;
    }

    public SerializableResult() {
        this(null);
    }

    public Result result() {
        if (this.cachedResult == null) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"Result should have been provided in constructor or when deserializing");
        }
        return this.cachedResult;
    }

    @Override
    public void readExternal(ObjectInput in) {
        if (in.readByte() != SerializableResult$.MODULE$.encodingVersion()) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"Result was serialised from a different version of Play");
        }
        int status = in.readInt();
        int headerLength = in.readInt();
        Builder mapBuilder = Predef$.MODULE$.Map().newBuilder();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), headerLength).foreach((Function1 & Serializable)x$1 -> SerializableResult.$anonfun$1(in, mapBuilder, BoxesRunTime.unboxToInt((Object)x$1)));
        Map headerMap = (Map)mapBuilder.result();
        boolean hasContentType = in.readBoolean();
        None$ contentType = hasContentType ? Some$.MODULE$.apply((Object)in.readUTF()) : None$.MODULE$;
        int sizeOfBody = in.readInt();
        byte[] buffer = new byte[sizeOfBody];
        SerializableResult.readBytes$1(in, buffer, 0, sizeOfBody);
        HttpEntity.Strict body = HttpEntity.Strict$.MODULE$.apply(ByteString$.MODULE$.fromArrayUnsafe(buffer), (Option)contentType);
        this.cachedResult = Result$.MODULE$.apply(ResponseHeader$.MODULE$.apply(status, headerMap, ResponseHeader$.MODULE$.apply$default$3()), (HttpEntity)body, Result$.MODULE$.$lessinit$greater$default$3(), Result$.MODULE$.$lessinit$greater$default$4(), Result$.MODULE$.$lessinit$greater$default$5(), Result$.MODULE$.$lessinit$greater$default$6());
    }

    @Override
    public void writeExternal(ObjectOutput out) {
        out.writeByte(Byte$.MODULE$.byte2int(SerializableResult$.MODULE$.encodingVersion()));
        out.writeInt(this.cachedResult.header().status());
        Map headerMap = this.cachedResult.header().headers();
        out.writeInt(headerMap.size());
        headerMap.withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                String value = (String)tuple2._2();
                return true;
            }
            return false;
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                String value = (String)tuple2._2();
                out.writeUTF(name);
                out.writeUTF(value);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        out.writeBoolean(this.cachedResult.body().contentType().nonEmpty());
        this.cachedResult.body().contentType().foreach((Function1)(JProcedure1 & Serializable)ct -> out.writeUTF((String)ct));
        HttpEntity httpEntity = this.cachedResult.body();
        if (!(httpEntity instanceof HttpEntity.Strict)) {
            HttpEntity other = httpEntity;
            throw new IllegalStateException("Non strict body cannot be materialized");
        }
        HttpEntity.Strict strict = HttpEntity.Strict$.MODULE$.unapply((HttpEntity.Strict)httpEntity);
        ByteString byteString = strict._1();
        Option option = strict._2();
        ByteString data = byteString;
        ByteString body = data;
        out.writeInt(body.length());
        out.write(body.toArrayUnsafe());
    }

    private static final /* synthetic */ Builder $anonfun$1(ObjectInput in$1, Builder mapBuilder$1, int x$1) {
        int n = x$1;
        String name = in$1.readUTF();
        String value = in$1.readUTF();
        return (Builder)mapBuilder$1.$plus$eq((Object)Tuple2$.MODULE$.apply((Object)name, (Object)value));
    }

    private static final void readBytes$1(ObjectInput in$2, byte[] buffer$1, int offset, int length) {
        while (length > 0) {
            int readLength = in$2.read(buffer$1, offset, length);
            int n = offset + readLength;
            int n2 = length - readLength;
            offset = n;
            length = n2;
        }
    }
}

