/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.script.jruby;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;
import org.picocontainer.ComponentFactory;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.Caching;
import org.picocontainer.classname.ClassLoadingPicoContainer;
import org.picocontainer.classname.DefaultClassLoadingPicoContainer;
import org.picocontainer.containers.EmptyPicoContainer;
import org.picocontainer.script.LifecycleMode;
import org.picocontainer.script.ScriptedContainerBuilder;
import org.picocontainer.script.ScriptedPicoContainerMarkupException;

public final class JRubyContainerBuilder
extends ScriptedContainerBuilder {
    public static final String MARKUP_EXCEPTION_PREFIX = "scriptedbuilder: ";
    private final String script;

    public JRubyContainerBuilder(Reader script, ClassLoader classLoader) {
        this(script, classLoader, LifecycleMode.AUTO_LIFECYCLE);
    }

    public JRubyContainerBuilder(Reader script, ClassLoader classLoader, LifecycleMode lifecycle) {
        super(script, classLoader, lifecycle);
        this.script = this.toString(script);
    }

    private String toString(Reader script) {
        char[] chars = new char[1024];
        StringWriter writer = new StringWriter();
        try {
            int charsRead;
            while ((charsRead = script.read(chars)) != -1) {
                writer.write(chars, 0, charsRead);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("unable to read script from reader", e);
        }
        return writer.toString();
    }

    protected PicoContainer createContainerFromScript(PicoContainer parentContainer, Object assemblyScope) {
        if (parentContainer == null) {
            parentContainer = new DefaultClassLoadingPicoContainer(this.getClassLoader(), (MutablePicoContainer)new DefaultPicoContainer((ComponentFactory)new Caching(), (PicoContainer)new EmptyPicoContainer()));
        }
        if (!(parentContainer instanceof ClassLoadingPicoContainer)) {
            parentContainer = parentContainer instanceof MutablePicoContainer ? new DefaultClassLoadingPicoContainer(this.getClassLoader(), (MutablePicoContainer)parentContainer) : new DefaultClassLoadingPicoContainer(this.getClassLoader(), (MutablePicoContainer)new DefaultPicoContainer((ComponentFactory)new Caching(), parentContainer));
        }
        RubyInstanceConfig rubyConfig = new RubyInstanceConfig();
        rubyConfig.setLoader(this.getClassLoader());
        Ruby ruby = JavaEmbedUtils.initialize((List)Collections.EMPTY_LIST, (RubyInstanceConfig)rubyConfig);
        ruby.getLoadService().require("org/picocontainer/script/jruby/scriptedbuilder");
        ruby.defineReadonlyVariable("$parent", JavaEmbedUtils.javaToRuby((Ruby)ruby, (Object)parentContainer));
        ruby.defineReadonlyVariable("$assembly_scope", JavaEmbedUtils.javaToRuby((Ruby)ruby, (Object)assemblyScope));
        try {
            IRubyObject result = JavaEmbedUtils.newRuntimeAdapter().eval(ruby, this.script);
            PicoContainer picoContainer = (PicoContainer)JavaEmbedUtils.rubyToJava((Ruby)ruby, (IRubyObject)result, PicoContainer.class);
            return picoContainer;
        }
        catch (RaiseException re) {
            if (re.getCause() instanceof ScriptedPicoContainerMarkupException) {
                throw (ScriptedPicoContainerMarkupException)re.getCause();
            }
            Object errorMessage = JavaEmbedUtils.rubyToJava((Ruby)ruby, (IRubyObject)re.getException().message, String.class);
            if (errorMessage instanceof String) {
                String message = (String)JavaEmbedUtils.rubyToJava((Ruby)ruby, (IRubyObject)re.getException().message, String.class);
                if (message.startsWith(MARKUP_EXCEPTION_PREFIX)) {
                    throw new ScriptedPicoContainerMarkupException(message.substring(MARKUP_EXCEPTION_PREFIX.length()));
                }
                throw new PicoCompositionException(message, (Throwable)re);
            }
            throw new PicoCompositionException(errorMessage.toString(), (Throwable)re);
        }
        finally {
            JavaEmbedUtils.terminate((Ruby)ruby);
        }
    }
}

