/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.script.groovy.nodes;

import java.util.Iterator;
import java.util.Map;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.script.ScriptedPicoContainerMarkupException;
import org.picocontainer.script.groovy.nodes.AbstractBuilderNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanNode
extends AbstractBuilderNode {
    public static final String NODE_NAME = "bean";
    public static final String BEAN_CLASS = "beanClass";

    public BeanNode() {
        super(NODE_NAME);
    }

    @Override
    public Object createNewNode(Object current, Map<String, Object> attributes) {
        Object bean = this.createBean(attributes);
        ((MutablePicoContainer)current).addComponent(bean);
        return bean;
    }

    protected Object createBean(Map<String, Object> attributes) {
        Class type = (Class)attributes.remove(BEAN_CLASS);
        if (type == null) {
            throw new ScriptedPicoContainerMarkupException("Bean must have a beanClass attribute");
        }
        try {
            Object bean = type.newInstance();
            Iterator<Map.Entry<String, Object>> i$ = attributes.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry<String, Object> o;
                Map.Entry<String, Object> entry = o = i$.next();
                String name = entry.getKey().toString();
                Object value = entry.getValue();
                InvokerHelper.setProperty(bean, (String)name, (Object)value);
            }
            return bean;
        }
        catch (IllegalAccessException e) {
            throw new ScriptedPicoContainerMarkupException("Failed to create bean of type '" + type + "'. Reason: " + e, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ScriptedPicoContainerMarkupException("Failed to create bean of type " + type + "'. Reason: " + e, (Throwable)e);
        }
    }

    @Override
    public void validateScriptedAttributes(Map<String, Object> specifiedAttributes) throws ScriptedPicoContainerMarkupException {
        if (!specifiedAttributes.containsKey(BEAN_CLASS)) {
            throw new ScriptedPicoContainerMarkupException("Attribute beanClass is required.");
        }
    }
}

