/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.script.groovy;

import java.util.Collection;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

public class GroovyScriptGenerator {
    public String generateScript(MutablePicoContainer pico) {
        StringBuffer groovy = new StringBuffer();
        groovy.append("pico = new org.picocontainer.classname.DefaultClassLoadingPicoContainer()\n");
        Collection componentAdapters = pico.getComponentAdapters();
        for (ComponentAdapter componentAdapter : componentAdapters) {
            Object componentKey = componentAdapter.getComponentKey();
            String groovyKey = null;
            if (componentKey instanceof Class) {
                groovyKey = ((Class)componentKey).getName();
            } else if (componentKey instanceof String) {
                groovyKey = "\"" + componentKey + "\"";
            }
            Object componentInstance = componentAdapter.getComponentInstance((PicoContainer)pico, null);
            if (componentInstance instanceof String) {
                groovy.append("pico.addComponent(").append(groovyKey).append(", (Object) \"").append(componentInstance).append("\")\n");
                continue;
            }
            groovy.append("pico.addComponent(").append(groovyKey).append(", ").append(componentInstance.getClass().getName()).append(")\n");
        }
        return groovy.toString();
    }
}

