/*
 * Decompiled with CFR 0.152.
 */
package org.parceler;

import android.os.Parcelable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.parceler.ParcelerRuntimeException;
import org.parceler.Repository;

public final class Parcels {
    public static final String PARCELS_NAME = "Parcels";
    public static final String PARCELS_REPOSITORY_NAME = "Parceler$Parcels";
    public static final String PARCELS_PACKAGE = "org.parceler";
    public static final String IMPL_EXT = "$Parcel";
    private static final ParcelCodeRepository REPOSITORY = new ParcelCodeRepository();

    private Parcels() {
    }

    protected static void update(ClassLoader classLoader) {
        REPOSITORY.loadRepository(classLoader);
    }

    public static <T> Parcelable wrap(T input) {
        ParcelableFactory parcelableFactory = REPOSITORY.get(input.getClass());
        return parcelableFactory.buildParcelable(input);
    }

    private static final class ParcelCodeRepository {
        private ConcurrentMap<Class, ParcelableFactory> generatedMap = new ConcurrentHashMap<Class, ParcelableFactory>();

        public ParcelCodeRepository() {
            this.loadRepository(this.getClass().getClassLoader());
        }

        public ParcelableFactory get(Class clazz) {
            ParcelableFactory result = (ParcelableFactory)this.generatedMap.get(clazz);
            if (result == null) {
                ParcelableFactory value = this.findClass(clazz);
                if (value == null) {
                    throw new ParcelerRuntimeException("Unable to create ParcelableFactory");
                }
                result = this.generatedMap.putIfAbsent(clazz, value);
                if (result == null) {
                    result = value;
                }
            }
            return result;
        }

        public ParcelableFactory findClass(Class clazz) {
            try {
                Class<?> parcelWrapperClass = Class.forName(clazz.getName() + Parcels.IMPL_EXT);
                return new ParcelableFactoryReflectionProxy(clazz, parcelWrapperClass);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        public final void loadRepository(ClassLoader classLoader) {
            try {
                Class<?> repositoryClass = classLoader.loadClass("org.parceler.Parceler$Parcels");
                Repository instance = (Repository)repositoryClass.newInstance();
                this.generatedMap.putAll(instance.get());
            }
            catch (ClassNotFoundException e) {
            }
            catch (InstantiationException e) {
                throw new ParcelerRuntimeException("Unable to instantiate generated Repository", e);
            }
            catch (IllegalAccessException e) {
                throw new ParcelerRuntimeException("Unable to access generated Repository", e);
            }
        }
    }

    private static final class ParcelableFactoryReflectionProxy<T>
    implements ParcelableFactory<T> {
        private final Constructor<? extends Parcelable> constructor;

        public ParcelableFactoryReflectionProxy(Class<T> parcelClass, Class<? extends Parcelable> parcelWrapperClass) {
            try {
                this.constructor = parcelWrapperClass.getConstructor(parcelClass);
            }
            catch (NoSuchMethodException e) {
                throw new ParcelerRuntimeException("Unable to create ParcelFactory Type", e);
            }
        }

        @Override
        public Parcelable buildParcelable(T input) {
            try {
                return this.constructor.newInstance(input);
            }
            catch (InstantiationException e) {
                throw new ParcelerRuntimeException("Unable to create ParcelFactory Type", e);
            }
            catch (IllegalAccessException e) {
                throw new ParcelerRuntimeException("Unable to create ParcelFactory Type", e);
            }
            catch (InvocationTargetException e) {
                throw new ParcelerRuntimeException("Unable to create ParcelFactory Type", e);
            }
        }
    }

    public static interface ParcelableFactory<T> {
        public static final String BUILD_PARCELABLE = "buildParcelable";

        public Parcelable buildParcelable(T var1);
    }
}

