/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.ui.prefs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.owasp.jbrofuzz.ui.JBroFuzzWindow;
import org.owasp.jbrofuzz.ui.prefs.AbstractPrefsPanel;
import org.owasp.jbrofuzz.ui.prefs.DatabasePanel;
import org.owasp.jbrofuzz.ui.prefs.DirsPPanel;
import org.owasp.jbrofuzz.ui.prefs.FuzzPPanel;
import org.owasp.jbrofuzz.ui.prefs.OutputPPanel;
import org.owasp.jbrofuzz.ui.prefs.PrefsPPanel;
import org.owasp.jbrofuzz.ui.prefs.UpdatePPanel;
import org.owasp.jbrofuzz.ui.prefs.WirePPanel;
import org.owasp.jbrofuzz.version.ImageCreator;
import org.owasp.jbrofuzz.version.JBroFuzzFormat;

public class PrefDialog
extends JDialog
implements TreeSelectionListener {
    private static final long serialVersionUID = -6206219050510937296L;
    private static final int SIZE_X = 850;
    private static final int SIZE_Y = 800;
    private final JTree tree;
    private final JSplitPane splitPane;
    private final AbstractPrefsPanel[] panels = new AbstractPrefsPanel[7];
    private final JBroFuzzWindow parent;
    private final JButton applyBut;

    public PrefDialog(JBroFuzzWindow parent, PrefsPanel panelType) {
        super(parent, " JBroFuzz - Preferences ", true);
        this.setIconImage(ImageCreator.IMG_FRAME.getImage());
        this.setLayout(new BorderLayout());
        this.setFont(new Font("Verdana", 0, 12));
        this.parent = parent;
        this.panels[0] = new PrefsPPanel(this);
        this.panels[1] = new DirsPPanel(this);
        this.panels[2] = new FuzzPPanel(this);
        this.panels[3] = new WirePPanel(this);
        this.panels[4] = new OutputPPanel(this);
        this.panels[5] = new DatabasePanel(this);
        this.panels[6] = new UpdatePPanel(this);
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(this.panels[0].getName());
        for (int i = 1; i < this.panels.length; ++i) {
            top.add(this.panels[i].getTreeNode());
        }
        this.tree = new JTree(top);
        this.tree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        JScrollPane leftScrollPane = new JScrollPane(this.tree);
        this.splitPane = new JSplitPane(1);
        this.splitPane.setLeftComponent(leftScrollPane);
        this.splitPane.setRightComponent(this.panels[0]);
        this.splitPane.setOneTouchExpandable(false);
        this.splitPane.setDividerLocation(150);
        leftScrollPane.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        for (AbstractPrefsPanel jp : this.panels) {
            jp.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        }
        this.splitPane.setDividerLocation(150);
        TreeNode root = (TreeNode)this.tree.getModel().getRoot();
        parent.getPanelPayloads().expandAll(this.tree, new TreePath(root), true);
        switch (panelType) {
            case PREFERENCES: {
                this.tree.setSelectionRow(0);
                break;
            }
            case DIRECTORIES: {
                this.tree.setSelectionRow(1);
                break;
            }
            case FUZZING: {
                this.tree.setSelectionRow(2);
                break;
            }
            case ONTHEWIRE: {
                this.tree.setSelectionRow(3);
                break;
            }
            case OUTPUT: {
                this.tree.setSelectionRow(4);
                break;
            }
            case UPDATE: {
                this.tree.setSelectionRow(5);
                break;
            }
            default: {
                this.tree.setSelectionRow(0);
            }
        }
        JButton okBut = new JButton("  OK  ");
        JButton cancelBut = new JButton("Cancel");
        this.applyBut = new JButton(" Apply ");
        okBut.setEnabled(true);
        cancelBut.setEnabled(true);
        this.applyBut.setEnabled(false);
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 15, 15));
        buttonPanel.add(okBut);
        buttonPanel.add(cancelBut);
        buttonPanel.add(this.applyBut);
        okBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent okEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (AbstractPrefsPanel p : PrefDialog.this.panels) {
                            p.apply();
                        }
                        PrefDialog.this.dispose();
                    }
                });
            }
        });
        cancelBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent cancelEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PrefDialog.this.dispose();
                    }
                });
            }
        });
        this.applyBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent applyEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (AbstractPrefsPanel p : PrefDialog.this.panels) {
                            p.apply();
                        }
                        PrefDialog.this.applyBut.setEnabled(false);
                    }
                });
            }
        });
        this.tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent kEvent) {
                if (kEvent.getKeyCode() == 27) {
                    PrefDialog.this.dispose();
                }
            }
        });
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setLocation(parent.getLocation().x + (parent.getWidth() - 850) / 2, parent.getLocation().y + (parent.getHeight() - 800) / 2);
        this.setSize(850, 800);
        this.setMinimumSize(new Dimension(850, 800));
        this.setResizable(true);
        this.setVisible(true);
    }

    @Override
    public void valueChanged(TreeSelectionEvent tEvent) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        for (int i = 0; i < this.panels.length; ++i) {
            if (!node.toString().equalsIgnoreCase(this.panels[i].getName())) continue;
            this.splitPane.setRightComponent(this.panels[i]);
            this.splitPane.setDividerLocation(this.splitPane.getDividerLocation());
        }
        if (this.applyBut != null) {
            this.applyBut.setEnabled(true);
        }
    }

    protected JBroFuzzWindow getJBroFuzzWindow() {
        return this.parent;
    }

    protected void setApplyEnabled(boolean applyOn) {
        this.applyBut.setEnabled(applyOn);
    }

    public static enum PrefsPanel {
        PREFERENCES,
        DIRECTORIES,
        FUZZING,
        ONTHEWIRE,
        OUTPUT,
        DATABASE,
        UPDATE;

    }
}

