/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.ui.prefs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.owasp.jbrofuzz.JBroFuzz;
import org.owasp.jbrofuzz.ui.prefs.AbstractPrefsPanel;
import org.owasp.jbrofuzz.ui.prefs.PrefDialog;
import org.owasp.jbrofuzz.version.JBroFuzzPrefs;

public class DatabasePanel
extends AbstractPrefsPanel {
    private static final long serialVersionUID = 6601607213870707446L;
    private final JCheckBox proxyEnabledBox;
    private final JCheckBox proxyReqAuthBox;
    private final JTextField dbNameTextField;
    private final JTextField userTextField;
    private final JTextField portTextField;
    private final JTextField hostTextField;
    private final JTextField passTextField;
    private final JComboBox authTypeBox;
    private final JComboBox dbTypeBox;
    private static final Dimension V_SPACE = new Dimension(0, 20);

    protected DatabasePanel(final PrefDialog dialog) {
        super("Database Configuration");
        boolean proxyEnabled = JBroFuzz.PREFS.getBoolean(JBroFuzzPrefs.DBSETTINGS[0].getId(), false);
        this.proxyEnabledBox = new JCheckBox(JBroFuzzPrefs.DBSETTINGS[0].getTitle(), proxyEnabled);
        this.proxyEnabledBox.setToolTipText(JBroFuzzPrefs.DBSETTINGS[0].getTooltip());
        this.proxyEnabledBox.setBorderPaintedFlat(true);
        String hostEntry = JBroFuzz.PREFS.get(JBroFuzzPrefs.DBSETTINGS[1].getId(), "");
        this.hostTextField = new JTextField(hostEntry);
        this.hostTextField.setToolTipText(JBroFuzzPrefs.DBSETTINGS[1].getTooltip());
        this.hostTextField.setFont(new Font("Verdana", 0, 12));
        this.hostTextField.setMargin(new Insets(1, 1, 1, 1));
        String portEntry = JBroFuzz.PREFS.get(JBroFuzzPrefs.DBSETTINGS[2].getId(), "");
        this.portTextField = new JTextField(portEntry);
        this.portTextField.setToolTipText(JBroFuzzPrefs.DBSETTINGS[2].getTooltip());
        this.portTextField.setFont(new Font("Verdana", 0, 12));
        this.portTextField.setMargin(new Insets(1, 1, 1, 1));
        boolean proxyReqAuth = JBroFuzz.PREFS.getBoolean(JBroFuzzPrefs.DBSETTINGS[3].getId(), false);
        this.proxyReqAuthBox = new JCheckBox(JBroFuzzPrefs.DBSETTINGS[3].getTitle(), proxyReqAuth);
        this.proxyReqAuthBox.setToolTipText(JBroFuzzPrefs.DBSETTINGS[3].getTooltip());
        this.proxyReqAuthBox.setBorderPaintedFlat(true);
        String[] authTypeArray = new String[]{"HTTP"};
        this.authTypeBox = new JComboBox<String>(authTypeArray);
        this.authTypeBox.setToolTipText(JBroFuzzPrefs.DBSETTINGS[4].getTooltip());
        String userEntry = JBroFuzz.PREFS.get(JBroFuzzPrefs.DBSETTINGS[5].getId(), "");
        this.userTextField = new JTextField(userEntry);
        this.userTextField.setToolTipText(JBroFuzzPrefs.DBSETTINGS[5].getTooltip());
        this.userTextField.setFont(new Font("Verdana", 0, 12));
        this.userTextField.setMargin(new Insets(1, 1, 1, 1));
        this.userTextField.setPreferredSize(new Dimension(80, 20));
        String passEntry = JBroFuzz.PREFS.get(JBroFuzzPrefs.DBSETTINGS[6].getId(), "");
        this.passTextField = new JTextField(passEntry);
        this.passTextField.setToolTipText(JBroFuzzPrefs.DBSETTINGS[6].getTooltip());
        this.passTextField.setFont(new Font("Verdana", 0, 12));
        this.passTextField.setMargin(new Insets(1, 1, 1, 1));
        this.passTextField.setPreferredSize(new Dimension(80, 20));
        String[] dbTypeArray = new String[]{"SQLite", "None"};
        this.dbTypeBox = new JComboBox<String>(dbTypeArray);
        this.dbTypeBox.setToolTipText(JBroFuzzPrefs.DBSETTINGS[11].getTooltip());
        String dbNameEntry = JBroFuzz.PREFS.get(JBroFuzzPrefs.DBSETTINGS[12].getId(), "");
        this.dbNameTextField = new JTextField(dbNameEntry);
        this.dbNameTextField.setToolTipText(JBroFuzzPrefs.DBSETTINGS[12].getTooltip());
        this.dbNameTextField.setFont(new Font("Veranda", 0, 12));
        this.dbNameTextField.setMargin(new Insets(1, 1, 1, 1));
        this.dbNameTextField.setPreferredSize(new Dimension(80, 20));
        JPanel hostPortPanel = new JPanel(new GridBagLayout());
        hostPortPanel.setAlignmentX(0.0f);
        hostPortPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(JBroFuzzPrefs.DBSETTINGS[1].getTitle() + " / " + JBroFuzzPrefs.DBSETTINGS[2].getTitle()), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 4;
        c.ipadx = 250;
        hostPortPanel.add((Component)this.hostTextField, c);
        c.fill = 2;
        c.weightx = 0.5;
        c.gridx = 4;
        c.gridy = 0;
        c.gridwidth = 1;
        c.ipadx = 0;
        hostPortPanel.add((Component)this.portTextField, c);
        JPanel dbTypePanel = new JPanel(new BorderLayout());
        Dimension dim = new Dimension();
        dim.height = 10;
        dbTypePanel.setSize(dim);
        dbTypePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("DB-Type"), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        dbTypePanel.add(new JLabel(""));
        dbTypePanel.add((Component)this.dbTypeBox, "Before");
        dbTypePanel.add((Component)this.dbNameTextField, "Center");
        JPanel userPassPanel = new JPanel(new FlowLayout(0, 15, 0));
        userPassPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Authentication"), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        userPassPanel.add(this.authTypeBox);
        userPassPanel.add(new JLabel(JBroFuzzPrefs.DBSETTINGS[5].getTitle()));
        userPassPanel.add(this.userTextField);
        userPassPanel.add(new JLabel(JBroFuzzPrefs.DBSETTINGS[6].getTitle()));
        userPassPanel.add(this.passTextField);
        userPassPanel.setAlignmentX(0.0f);
        if (this.proxyEnabledBox.isSelected()) {
            this.hostTextField.setEnabled(true);
            this.portTextField.setEnabled(true);
            this.proxyReqAuthBox.setEnabled(true);
            this.authTypeBox.setEnabled(true);
            this.userTextField.setEnabled(true);
            this.passTextField.setEnabled(true);
            this.dbTypeBox.setSelectedIndex(1);
        } else {
            this.hostTextField.setEnabled(false);
            this.portTextField.setEnabled(false);
            this.proxyReqAuthBox.setEnabled(false);
            this.authTypeBox.setEnabled(false);
            this.userTextField.setEnabled(false);
            this.passTextField.setEnabled(false);
            this.dbTypeBox.setSelectedIndex(0);
        }
        if (this.proxyReqAuthBox.isSelected()) {
            this.authTypeBox.setEnabled(true);
            this.userTextField.setEnabled(true);
            this.passTextField.setEnabled(true);
            this.dbTypeBox.setSelectedIndex(1);
        } else {
            this.authTypeBox.setEnabled(false);
            this.userTextField.setEnabled(false);
            this.passTextField.setEnabled(false);
        }
        if (this.dbTypeBox.getSelectedIndex() == 3) {
            this.proxyReqAuthBox.setEnabled(false);
            this.proxyEnabledBox.setSelected(false);
            this.proxyEnabledBox.setEnabled(false);
            this.proxyReqAuthBox.setSelected(false);
            this.authTypeBox.setEnabled(false);
        } else {
            this.proxyEnabledBox.setEnabled(true);
        }
        this.dbTypeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent1) {
                if (DatabasePanel.this.dbTypeBox.getSelectedIndex() == 1) {
                    DatabasePanel.this.proxyReqAuthBox.setEnabled(false);
                    DatabasePanel.this.proxyEnabledBox.setSelected(false);
                    DatabasePanel.this.proxyEnabledBox.setEnabled(false);
                    DatabasePanel.this.proxyReqAuthBox.setSelected(false);
                    DatabasePanel.this.hostTextField.setText("");
                    DatabasePanel.this.portTextField.setText("");
                    DatabasePanel.this.userTextField.setText("");
                    DatabasePanel.this.passTextField.setText("");
                    DatabasePanel.this.dbNameTextField.setEnabled(false);
                    DatabasePanel.this.authTypeBox.setEnabled(false);
                } else {
                    DatabasePanel.this.proxyEnabledBox.setEnabled(true);
                    DatabasePanel.this.dbNameTextField.setEnabled(true);
                }
            }
        });
        this.proxyEnabledBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent1) {
                if (DatabasePanel.this.proxyEnabledBox.isSelected()) {
                    DatabasePanel.this.hostTextField.setEnabled(true);
                    DatabasePanel.this.portTextField.setEnabled(true);
                    DatabasePanel.this.proxyReqAuthBox.setEnabled(true);
                    DatabasePanel.this.authTypeBox.setEnabled(true);
                    DatabasePanel.this.userTextField.setEnabled(true);
                    DatabasePanel.this.passTextField.setEnabled(true);
                    DatabasePanel.this.dbTypeBox.setSelectedIndex(1);
                    if (DatabasePanel.this.proxyReqAuthBox.isSelected()) {
                        DatabasePanel.this.authTypeBox.setEnabled(true);
                        DatabasePanel.this.userTextField.setEnabled(true);
                        DatabasePanel.this.passTextField.setEnabled(true);
                    } else {
                        DatabasePanel.this.authTypeBox.setEnabled(false);
                        DatabasePanel.this.userTextField.setEnabled(false);
                        DatabasePanel.this.passTextField.setEnabled(false);
                    }
                } else {
                    DatabasePanel.this.hostTextField.setEnabled(false);
                    DatabasePanel.this.portTextField.setEnabled(false);
                    DatabasePanel.this.proxyReqAuthBox.setEnabled(false);
                    DatabasePanel.this.authTypeBox.setEnabled(false);
                    DatabasePanel.this.userTextField.setEnabled(false);
                    DatabasePanel.this.passTextField.setEnabled(false);
                }
                dialog.setApplyEnabled(true);
            }
        });
        this.proxyReqAuthBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent2) {
                if (DatabasePanel.this.proxyReqAuthBox.isSelected()) {
                    DatabasePanel.this.authTypeBox.setEnabled(true);
                    DatabasePanel.this.userTextField.setEnabled(true);
                    DatabasePanel.this.passTextField.setEnabled(true);
                } else {
                    DatabasePanel.this.authTypeBox.setEnabled(false);
                    DatabasePanel.this.userTextField.setEnabled(false);
                    DatabasePanel.this.passTextField.setEnabled(false);
                }
                dialog.setApplyEnabled(true);
            }
        });
        this.add(Box.createRigidArea(V_SPACE));
        this.add(Box.createRigidArea(V_SPACE));
        this.add(Box.createRigidArea(V_SPACE));
        this.add(Box.createRigidArea(V_SPACE));
        this.add(Box.createRigidArea(V_SPACE));
        this.add(dbTypePanel);
        this.add(Box.createRigidArea(new Dimension(120, 300)));
        this.add(Box.createRigidArea(new Dimension(80, 300)));
        if (!JBroFuzz.PREFS.get(JBroFuzzPrefs.DBSETTINGS[11].getId(), "").equals("")) {
            for (int i = 0; i < dbTypeArray.length; ++i) {
                if (!JBroFuzz.PREFS.get(JBroFuzzPrefs.DBSETTINGS[11].getId(), "").toLowerCase().trim().equals(dbTypeArray[i].toLowerCase().trim())) continue;
                this.dbTypeBox.setSelectedIndex(i);
                this.dbTypeBox.updateUI();
                break;
            }
        }
    }

    @Override
    protected void apply() {
        JBroFuzz.PREFS.putBoolean(JBroFuzzPrefs.DBSETTINGS[0].getId(), this.proxyEnabledBox.isSelected());
        if (this.dbTypeBox.getSelectedIndex() == 3) {
            this.proxyEnabledBox.setSelected(false);
            this.proxyReqAuthBox.setSelected(false);
            JBroFuzz.PREFS.put(JBroFuzzPrefs.DBSETTINGS[1].getId(), "");
            JBroFuzz.PREFS.put(JBroFuzzPrefs.DBSETTINGS[2].getId(), "");
            JBroFuzz.PREFS.put(JBroFuzzPrefs.DBSETTINGS[3].getId(), "");
            JBroFuzz.PREFS.put(JBroFuzzPrefs.DBSETTINGS[4].getId(), "");
            JBroFuzz.PREFS.put(JBroFuzzPrefs.DBSETTINGS[5].getId(), "");
            JBroFuzz.PREFS.put(JBroFuzzPrefs.DBSETTINGS[6].getId(), "");
            JBroFuzz.PREFS.put(JBroFuzzPrefs.DBSETTINGS[7].getId(), "");
            JBroFuzz.PREFS.put(JBroFuzzPrefs.DBSETTINGS[8].getId(), "");
            JBroFuzz.PREFS.put(JBroFuzzPrefs.DBSETTINGS[9].getId(), "");
            JBroFuzz.PREFS.put(JBroFuzzPrefs.DBSETTINGS[10].getId(), "");
            JBroFuzz.PREFS.put(JBroFuzzPrefs.DBSETTINGS[11].getId(), "");
            JBroFuzz.PREFS.put(JBroFuzzPrefs.DBSETTINGS[12].getId(), "");
        } else {
            if (this.proxyEnabledBox.isSelected()) {
                JBroFuzz.PREFS.put(JBroFuzzPrefs.DBSETTINGS[1].getId(), this.hostTextField.getText());
                JBroFuzz.PREFS.put(JBroFuzzPrefs.DBSETTINGS[2].getId(), this.portTextField.getText());
                JBroFuzz.PREFS.putBoolean(JBroFuzzPrefs.DBSETTINGS[3].getId(), this.proxyReqAuthBox.isSelected());
                if (this.proxyReqAuthBox.isSelected()) {
                    JBroFuzz.PREFS.put(JBroFuzzPrefs.DBSETTINGS[4].getId(), this.authTypeBox.getSelectedItem().toString());
                    JBroFuzz.PREFS.put(JBroFuzzPrefs.DBSETTINGS[5].getId(), this.userTextField.getText());
                    JBroFuzz.PREFS.put(JBroFuzzPrefs.DBSETTINGS[6].getId(), this.passTextField.getText());
                }
            }
            JBroFuzz.PREFS.put(JBroFuzzPrefs.DBSETTINGS[11].getId(), this.dbTypeBox.getSelectedItem().toString());
            JBroFuzz.PREFS.put(JBroFuzzPrefs.DBSETTINGS[12].getId(), this.dbNameTextField.getText());
        }
    }
}

