/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.ui.menu;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.owasp.jbrofuzz.system.Logger;
import org.owasp.jbrofuzz.ui.AbstractPanel;
import org.owasp.jbrofuzz.ui.JBroFuzzWindow;
import org.owasp.jbrofuzz.ui.actions.CopyAction;
import org.owasp.jbrofuzz.ui.actions.CutAction;
import org.owasp.jbrofuzz.ui.actions.PasteAction;
import org.owasp.jbrofuzz.ui.actions.SelectAllAction;
import org.owasp.jbrofuzz.ui.menu.JMenuFile;
import org.owasp.jbrofuzz.ui.menu.JMenuHelp;
import org.owasp.jbrofuzz.ui.prefs.PrefDialog;
import org.owasp.jbrofuzz.update.CheckForUpdates;
import org.owasp.jbrofuzz.version.ImageCreator;

public class JBroFuzzMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 6653470603012430621L;
    private final JBroFuzzWindow mFrameWindow;
    private final JMenu view;
    private final JMenu panel;
    private final JMenu options;
    private final JMenuItem start;
    private final JMenuItem pause;
    private final JMenuItem stop;
    private final JMenuItem add;
    private final JMenuItem remove;
    private final JCheckBoxMenuItem graphing;
    private final JCheckBoxMenuItem fuzzing;
    private final JCheckBoxMenuItem payloads;
    private final JCheckBoxMenuItem system;

    public JBroFuzzMenuBar(JBroFuzzWindow mFrameWindow) {
        this.mFrameWindow = mFrameWindow;
        JMenu edit = new JMenu("Edit");
        this.view = new JMenu("View");
        this.panel = new JMenu("Panel");
        this.options = new JMenu("Options");
        this.add(new JMenuFile(this));
        this.add(edit);
        this.add(this.view);
        this.add(this.panel);
        this.add(this.options);
        this.add(new JMenuHelp(this));
        JMenuItem cut = new JMenuItem(new CutAction());
        JMenuItem copy = new JMenuItem(new CopyAction());
        JMenuItem paste = new JMenuItem(new PasteAction());
        JMenuItem selectAll = new JMenuItem(new SelectAllAction());
        cut.setAccelerator(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        cut.setIcon(ImageCreator.IMG_CUT);
        copy.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        copy.setIcon(ImageCreator.IMG_COPY);
        paste.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        paste.setIcon(ImageCreator.IMG_PASTE);
        selectAll.setAccelerator(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        selectAll.setIcon(ImageCreator.IMG_SELECTALL);
        edit.add(cut);
        edit.add(copy);
        edit.add(paste);
        edit.addSeparator();
        edit.add(selectAll);
        JMenu showHide = new JMenu("Show/Hide");
        showHide.setIcon(ImageCreator.IMG_SHOW_HIDE);
        this.graphing = new JCheckBoxMenuItem("Graphing", true);
        this.fuzzing = new JCheckBoxMenuItem("Fuzzing", true);
        this.payloads = new JCheckBoxMenuItem("Payloads", false);
        this.system = new JCheckBoxMenuItem("System", false);
        JMenuItem showAll = new JMenuItem("Show All", ImageCreator.IMG_SHOW_ALL);
        JMenuItem hideAll = new JMenuItem("Hide All");
        showHide.add(this.fuzzing);
        showHide.add(this.payloads);
        showHide.add(this.graphing);
        showHide.add(this.system);
        this.fuzzing.setState(true);
        this.payloads.setState(true);
        this.graphing.setState(true);
        this.system.setState(true);
        this.view.add(showHide);
        this.view.addSeparator();
        this.view.add(showAll);
        this.view.add(hideAll);
        this.view.addSeparator();
        JMenu lookAndFeel = new JMenu("Look and Feel");
        lookAndFeel.setIcon(ImageCreator.IMG_LKF);
        UIManager.LookAndFeelInfo[] installedFeels = UIManager.getInstalledLookAndFeels();
        ButtonGroup group = new ButtonGroup();
        for (int i = 0; i < Math.min(installedFeels.length, 10); ++i) {
            JRadioButtonMenuItem rButton1 = new JRadioButtonMenuItem(installedFeels[i].getName());
            group.add(rButton1);
            lookAndFeel.add(rButton1);
            rButton1.setSelected(UIManager.getLookAndFeel().getName().equalsIgnoreCase(installedFeels[i].getName()));
            rButton1.putClientProperty("Look and Feel Name", installedFeels[i]);
            rButton1.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent iEvent) {
                    JRadioButtonMenuItem rbi = (JRadioButtonMenuItem)iEvent.getSource();
                    if (rbi.isSelected()) {
                        final UIManager.LookAndFeelInfo info = (UIManager.LookAndFeelInfo)rbi.getClientProperty("Look and Feel Name");
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    UIManager.setLookAndFeel(info.getClassName());
                                    SwingUtilities.updateComponentTreeUI(JBroFuzzMenuBar.this.getFrame());
                                }
                                catch (UnsupportedLookAndFeelException e) {
                                    Logger.log("An error occured while setting the Look & Feel", 5);
                                }
                                catch (IllegalAccessException e) {
                                    Logger.log("An error occured while setting the Look & Feel", 5);
                                }
                                catch (ClassNotFoundException e) {
                                    Logger.log("An error occured while setting the Look & Feel", 5);
                                }
                                catch (InstantiationException e) {
                                    Logger.log("An error occured while setting the Look & Feel", 5);
                                }
                            }
                        });
                    }
                }
            });
        }
        this.view.add(lookAndFeel);
        this.start = new JMenuItem("Start", ImageCreator.IMG_START);
        this.pause = new JMenuItem("Pause", ImageCreator.IMG_PAUSE);
        this.pause.setEnabled(false);
        this.stop = new JMenuItem("Stop", ImageCreator.IMG_STOP);
        this.add = new JMenuItem("Add", ImageCreator.IMG_ADD);
        this.remove = new JMenuItem("Remove", ImageCreator.IMG_REMOVE);
        this.add.setAccelerator(KeyStroke.getKeyStroke(61, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.remove.setAccelerator(KeyStroke.getKeyStroke(45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.pause.setAccelerator(KeyStroke.getKeyStroke(74, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.start.setAccelerator(KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.stop.setAccelerator(KeyStroke.getKeyStroke(8, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.panel.add(this.start);
        this.panel.add(this.pause);
        this.panel.add(this.stop);
        this.panel.addSeparator();
        this.panel.add(this.add);
        this.panel.add(this.remove);
        JMenuItem headers = new JMenuItem("Browser Headers");
        JMenuItem encoderHash = new JMenuItem("Encoder/Hash...");
        JMenuItem updates = new JMenuItem("Check for Updates...", ImageCreator.IMG_UPDATE);
        JMenuItem preferences = new JMenuItem("Preferences", ImageCreator.IMG_PREFERENCES);
        headers.setAccelerator(KeyStroke.getKeyStroke(72, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        encoderHash.setAccelerator(KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        preferences.setAccelerator(KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.options.add(headers);
        this.options.addSeparator();
        this.options.add(encoderHash);
        this.options.add(updates);
        this.options.addSeparator();
        this.options.add(preferences);
        this.graphing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (JBroFuzzMenuBar.this.graphing.getState()) {
                            JBroFuzzMenuBar.this.getFrame().setTabShow(121);
                        } else {
                            JBroFuzzMenuBar.this.getFrame().setTabHide(121);
                        }
                    }
                });
            }
        });
        this.fuzzing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (JBroFuzzMenuBar.this.fuzzing.getState()) {
                            JBroFuzzMenuBar.this.getFrame().setTabShow(124);
                        } else {
                            JBroFuzzMenuBar.this.getFrame().setTabHide(124);
                        }
                    }
                });
            }
        });
        this.payloads.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!JBroFuzzMenuBar.this.payloads.getState()) {
                            JBroFuzzMenuBar.this.getFrame().setTabHide(125);
                        } else {
                            JBroFuzzMenuBar.this.getFrame().setTabShow(125);
                        }
                    }
                });
            }
        });
        this.system.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!JBroFuzzMenuBar.this.system.getState()) {
                            JBroFuzzMenuBar.this.getFrame().setTabHide(126);
                        } else {
                            JBroFuzzMenuBar.this.getFrame().setTabShow(126);
                        }
                    }
                });
            }
        });
        showAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JBroFuzzMenuBar.this.getFrame().setTabShow(121);
                        JBroFuzzMenuBar.this.graphing.setState(true);
                        JBroFuzzMenuBar.this.getFrame().setTabShow(124);
                        JBroFuzzMenuBar.this.fuzzing.setState(true);
                        JBroFuzzMenuBar.this.getFrame().setTabShow(125);
                        JBroFuzzMenuBar.this.payloads.setState(true);
                        JBroFuzzMenuBar.this.getFrame().setTabShow(126);
                        JBroFuzzMenuBar.this.system.setState(true);
                    }
                });
            }
        });
        hideAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JBroFuzzMenuBar.this.getFrame().setTabHide(121);
                        JBroFuzzMenuBar.this.graphing.setState(false);
                        JBroFuzzMenuBar.this.getFrame().setTabHide(124);
                        JBroFuzzMenuBar.this.fuzzing.setState(false);
                        JBroFuzzMenuBar.this.getFrame().setTabHide(125);
                        JBroFuzzMenuBar.this.payloads.setState(false);
                        JBroFuzzMenuBar.this.getFrame().setTabHide(126);
                        JBroFuzzMenuBar.this.system.setState(false);
                    }
                });
            }
        });
        this.start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final class Starter
                extends SwingWorker<String, Object> {
                    AbstractPanel p;

                    Starter() {
                    }

                    @Override
                    public String doInBackground() {
                        int c = JBroFuzzMenuBar.this.getFrame().getTp().getSelectedIndex();
                        this.p = (AbstractPanel)JBroFuzzMenuBar.this.getFrame().getTp().getComponent(c);
                        this.p.start();
                        return "start-menu-bar-done";
                    }

                    @Override
                    protected void done() {
                        this.p.stop();
                    }
                }
                new Starter().execute();
            }
        });
        this.stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int c = JBroFuzzMenuBar.this.getFrame().getTp().getSelectedIndex();
                        AbstractPanel p = (AbstractPanel)JBroFuzzMenuBar.this.getFrame().getTp().getComponent(c);
                        p.stop();
                    }
                });
            }
        });
        this.pause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Logger.log("Pause functionality has not yet being implemented", 2);
                    }
                });
            }
        });
        this.add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int c = JBroFuzzMenuBar.this.getFrame().getTp().getSelectedIndex();
                        AbstractPanel p = (AbstractPanel)JBroFuzzMenuBar.this.getFrame().getTp().getComponent(c);
                        p.add();
                    }
                });
            }
        });
        updates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        new CheckForUpdates(JBroFuzzMenuBar.this.getFrame());
                    }
                });
            }
        });
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int c = JBroFuzzMenuBar.this.getFrame().getTp().getSelectedIndex();
                        AbstractPanel p = (AbstractPanel)JBroFuzzMenuBar.this.getFrame().getTp().getComponent(c);
                        p.remove();
                    }
                });
            }
        });
        encoderHash.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(JBroFuzzMenuBar.this.getFrame(), "This functionality has now being replaced by a standalone\n\nJBroFuzzEncoder executable.\n\nIt can be found in the installation directory of JBroFuzz.");
                    }
                });
            }
        });
        headers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(JBroFuzzMenuBar.this.getFrame(), "This functionality has now being replaced by a standalone\n\nJBroFuzzHeader executable.\n\nIt can be found in the installation directory of JBroFuzz.");
                    }
                });
            }
        });
        preferences.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        new PrefDialog(JBroFuzzMenuBar.this.getFrame(), PrefDialog.PrefsPanel.PREFERENCES);
                    }
                });
            }
        });
    }

    public JBroFuzzWindow getFrame() {
        return this.mFrameWindow;
    }

    public void setEnabledPanelOptions(boolean[] b) {
        if (b.length == 5) {
            this.start.setEnabled(b[0]);
            this.stop.setEnabled(b[1]);
            this.pause.setEnabled(b[2]);
            this.add.setEnabled(b[3]);
            this.remove.setEnabled(b[4]);
        }
    }

    public void setSelectedPanelCheckBox(int checkBoxID) {
        if (checkBoxID == 124) {
            this.fuzzing.setEnabled(true);
        }
        if (checkBoxID == 121) {
            this.graphing.setEnabled(true);
        }
        if (checkBoxID == 125) {
            this.payloads.setEnabled(true);
        }
        if (checkBoxID == 126) {
            this.system.setEnabled(true);
        }
    }
}

