/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.owasp.jbrofuzz.JBroFuzz;
import org.owasp.jbrofuzz.fuzz.MessageContainer;
import org.owasp.jbrofuzz.graph.FileSystemTreeNode;
import org.owasp.jbrofuzz.graph.GraphingPanel;
import org.owasp.jbrofuzz.graph.utils.JohnyWalker;
import org.owasp.jbrofuzz.io.StorageInterface;
import org.owasp.jbrofuzz.system.Logger;
import org.owasp.jbrofuzz.ui.JBroFuzzWindow;
import org.owasp.jbrofuzz.version.JBroFuzzFormat;
import org.owasp.jbrofuzz.version.JBroFuzzPrefs;

public class FileHandler
implements StorageInterface {
    private File fuzzDirectory;
    private File rootDirectory;
    protected int count = 0;

    public FileHandler() {
        this.createNewLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File inputFile) {
        int counter;
        String fileName = inputFile.toString();
        if (inputFile.exists()) {
            if (inputFile.isDirectory()) {
                return "File is a directory:\n\n" + fileName;
            }
            if (!inputFile.canRead()) {
                return "File cannot be read:\n\n" + fileName;
            }
        } else {
            return "File does not exist:\n\n" + fileName;
        }
        BufferedInputStream in = null;
        FileInputStream fis = null;
        StringBuffer fileContents = new StringBuffer();
        try {
            int c;
            fis = new FileInputStream(inputFile);
            in = new BufferedInputStream(fis);
            for (counter = 0; (c = ((InputStream)in).read()) > 0 && counter <= 0x2000000; ++counter) {
                fileContents.append((char)c);
            }
            ((InputStream)in).close();
            fis.close();
        }
        catch (IOException e) {
            String string;
            try {
                string = "Attempting to open the file caused an I/O Error:\n\n" + fileName;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly((InputStream)fis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((InputStream)fis);
            return string;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((InputStream)fis);
        if (counter == 0x2000000) {
            fileContents.append("\n... stopped reading after 32 Mbytes.\n");
        }
        return fileContents.toString();
    }

    @Override
    public final void createNewLocation() {
        boolean saveElsewhere = JBroFuzz.PREFS.getBoolean(JBroFuzzPrefs.DIRS[1].getId(), true);
        String dirString = saveElsewhere ? JBroFuzz.PREFS.get(JBroFuzzPrefs.DIRS[0].getId(), System.getProperty("user.dir")) : System.getProperty("user.dir");
        this.rootDirectory = new File(dirString);
        StringBuffer directoryLocation = new StringBuffer();
        directoryLocation.append(dirString);
        directoryLocation.append(File.separator);
        directoryLocation.append("jbrofuzz");
        directoryLocation.append(File.separator);
        directoryLocation.append("fuzz");
        directoryLocation.append(File.separator);
        directoryLocation.append(JBroFuzzFormat.DATE);
        this.fuzzDirectory = new File(directoryLocation.toString());
        if (this.fuzzDirectory.exists()) {
            ++this.count;
            this.count %= 1000;
            directoryLocation.append('.');
            if (this.count < 10) {
                directoryLocation.append('0');
            }
            if (this.count < 100) {
                directoryLocation.append('0');
            }
            directoryLocation.append(this.count);
            this.fuzzDirectory = new File(directoryLocation.toString());
            if (this.fuzzDirectory.exists()) {
                Logger.log("The \"fuzz\" directory being used, already exists", 1);
            } else {
                boolean success = this.fuzzDirectory.mkdirs();
                if (!success) {
                    Logger.log("Failed to create new \"fuzz\" directory, no data will be written to file.", 4);
                    Logger.log("Are you using Vista? Right click on JBroFuzz and \"Run As Administrator\"", 0);
                }
            }
        } else {
            boolean success = this.fuzzDirectory.mkdirs();
            if (!success) {
                Logger.log("Failed to create \"fuzz\" directory, no data will be written to file.", 4);
                Logger.log("Run JBroFuzz from the command line: \"java -jar JBroFuzz.jar\"", 0);
                Logger.log("Are you using Vista? Right click on JBroFuzz and \"Run As Administrator\"", 0);
            }
        }
    }

    @Override
    public String getLocationCanonicalPath() {
        try {
            return this.rootDirectory.getCanonicalPath();
        }
        catch (IOException e) {
            return "";
        }
    }

    @Override
    public String getFuzzURIString(String fileName) {
        return new File(this.fuzzDirectory, fileName).toURI().toString();
    }

    @Override
    public String getLocationURIString() {
        return this.fuzzDirectory.toURI().toString();
    }

    @Override
    public void writeFuzzFile(MessageContainer outputMessage, String sessionId) {
        String fileName = outputMessage.getFileName() + ".html";
        File toWrite = new File(this.fuzzDirectory, fileName);
        try {
            FileUtils.touch((File)toWrite);
            FileUtils.writeStringToFile((File)toWrite, (String)outputMessage.toString());
        }
        catch (IOException e) {
            Logger.log("Error writting fuzz file: " + fileName, 3);
        }
    }

    @Override
    public Vector<MessageContainer> readFuzzFile(String fileName, String sessionId, JBroFuzzWindow mWindow) {
        return null;
    }

    @Override
    public String[] readTableRow(String sqlStatement) {
        return null;
    }

    @Override
    public FileSystemTreeNode getSystemTreeNodeFromWalker(GraphingPanel gPanel) {
        JohnyWalker test = new JohnyWalker(gPanel);
        test.run();
        return test.getFileSystemTreeNode();
    }
}

