/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.fuzz.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.owasp.jbrofuzz.core.Database;
import org.owasp.jbrofuzz.fuzz.ui.FuzzerTable;
import org.owasp.jbrofuzz.fuzz.ui.FuzzersTableModel;
import org.owasp.jbrofuzz.fuzz.ui.FuzzingPanel;
import org.owasp.jbrofuzz.fuzz.ui.RightClickPopups;
import org.owasp.jbrofuzz.system.Logger;

public class FuzzersPanel
extends JPanel {
    private static final long serialVersionUID = -9150023615230879357L;
    private FuzzersTableModel mFuzzTableModel;
    private FuzzerTable fuzzersTable;
    private FuzzingPanel fp;

    public FuzzersPanel(FuzzingPanel fp) {
        this.fp = fp;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Added Fuzzers Table"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.mFuzzTableModel = new FuzzersTableModel();
        this.fuzzersTable = new FuzzerTable(this.mFuzzTableModel);
        RightClickPopups.rightClickFuzzersTable(fp, this.fuzzersTable);
        JScrollPane fuzzersScrollPane = new JScrollPane(this.fuzzersTable);
        fuzzersScrollPane.setVerticalScrollBarPolicy(20);
        this.add((Component)fuzzersScrollPane, "Center");
        this.fuzzersTableSelectionListen();
    }

    public void clear() {
        while (this.fuzzersTable.getRowCount() > 0) {
            this.mFuzzTableModel.removeRow(0);
        }
    }

    public void clearFuzzersTable() {
        while (this.fuzzersTable.getRowCount() > 0) {
            this.mFuzzTableModel.removeRow(0);
        }
        this.fp.getTransformsPanel().clear();
        this.fp.getUrlField().requestFocusInWindow();
    }

    public int getRowCount() {
        return this.mFuzzTableModel.getRowCount();
    }

    public void updateFuzzerTable(FuzzerTable ft) {
        this.fuzzersTable.removeAll();
        JScrollPane scroll = new JScrollPane(ft, 22, 30);
        scroll.setVerticalScrollBarPolicy(20);
        this.add((Component)scroll, "Center");
        this.add((Component)this.fp.getControlPanel(), "East");
        this.updateUI();
    }

    private void fuzzersTableSelectionListen() {
        this.fuzzersTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                int row = FuzzersPanel.this.fuzzersTable.getSelectedRow();
                if (row > -1) {
                    FuzzersPanel.this.fp.getTransformsPanel().showTransformsList(row);
                }
            }
        });
    }

    public void addFuzzer(String fuzzerId, int point1, int point2) {
        Database cDatabase = this.fp.getFrame().getJBroFuzz().getDatabase();
        if (cDatabase.containsPrototype(fuzzerId)) {
            String type = cDatabase.getType(fuzzerId);
            this.mFuzzTableModel.addRow(fuzzerId, type, fuzzerId, point1, point2);
            this.fp.getTransformsPanel().addTransformsList();
        } else {
            Logger.log("Could not add the Fuzzer with ID: " + fuzzerId, 3);
        }
    }

    public String getCategory(int row) {
        return (String)this.mFuzzTableModel.getValueAt(row, 0);
    }

    public int getStart(int row) {
        return (Integer)this.mFuzzTableModel.getValueAt(row, 1);
    }

    public int getEnd(int row) {
        return (Integer)this.mFuzzTableModel.getValueAt(row, 2);
    }

    public void remove(boolean isAddedEnabled) {
        if (!isAddedEnabled) {
            return;
        }
        int rows = this.getRowCount();
        if (rows < 1) {
            return;
        }
        Object[] fuzzPoints = new String[rows];
        for (int i = 0; i < rows; ++i) {
            fuzzPoints[i] = this.mFuzzTableModel.getRow(i);
        }
        String selectedFuzzPoint = (String)JOptionPane.showInputDialog(this, "Select fuzzer to remove:", "Remove Fuzzer", 1, null, fuzzPoints, fuzzPoints[0]);
        if (selectedFuzzPoint != null) {
            this.mFuzzTableModel.removeRow(Integer.parseInt(selectedFuzzPoint.split(" - ")[0]));
            this.fp.getTransformsPanel().removeTransformsList(Integer.parseInt(selectedFuzzPoint.split(" - ")[0]));
        }
    }

    public FuzzerTable getFuzzersTable() {
        return this.fuzzersTable;
    }

    public void setFuzzersTable(FuzzerTable ft) {
        this.fuzzersTable = ft;
    }

    public FuzzersTableModel getFuzzersTableModel() {
        return this.mFuzzTableModel;
    }

    public void setFuzzersTableModel(FuzzersTableModel ftm) {
        this.mFuzzTableModel = ftm;
    }
}

