/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.fuzz.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.StringUtils;
import org.owasp.jbrofuzz.JBroFuzz;
import org.owasp.jbrofuzz.core.Prototype;
import org.owasp.jbrofuzz.encode.EncoderHashCore;
import org.owasp.jbrofuzz.system.Logger;
import org.owasp.jbrofuzz.ui.JBroFuzzWindow;
import org.owasp.jbrofuzz.util.JBroFuzzFileFilter;
import org.owasp.jbrofuzz.version.JBroFuzzPrefs;

public class OpenSession {
    private static final int MAX_CHARS = Short.MAX_VALUE;
    private JBroFuzzWindow mWindow;

    public OpenSession(JBroFuzzWindow mWindow) {
        new OpenSession(mWindow, "");
        this.mWindow = mWindow;
    }

    public OpenSession(JBroFuzzWindow mWindow, String fileName) {
        this.mWindow = mWindow;
        File file = null;
        mWindow.setTabShow(124);
        JBroFuzzFileFilter filter = new JBroFuzzFileFilter();
        String dirString = JBroFuzz.PREFS.get(JBroFuzzPrefs.DIRS[2].getId(), System.getProperty("user.dir"));
        JFileChooser fc = new JFileChooser();
        if (!(fileName.length() != 0 && !fileName.equals("") || JBroFuzzPrefs.DBSETTINGS[11].getId().equals("SQLite") || JBroFuzzPrefs.DBSETTINGS[11].getId().equals("CouchDB"))) {
            try {
                fc = new File(dirString).isDirectory() ? new JFileChooser(dirString) : new JFileChooser();
            }
            catch (SecurityException e1) {
                fc = new JFileChooser();
                Logger.log("A security exception occured, while attempting to point to a directory", 4);
            }
            fc.setFileFilter(filter);
            int returnVal = fc.showOpenDialog(mWindow);
            if (returnVal == 0) {
                file = fc.getSelectedFile();
                this.setUpFromFile(file, fc);
            }
        } else if (fileName.length() > 0 && !fileName.equals("")) {
            file = new File(fileName);
            this.setUpFromFile(file, fc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void setUpFromFile(File file, JFileChooser fc) {
        String path = file.getAbsolutePath().toLowerCase();
        JBroFuzzFileFilter jbfff = new JBroFuzzFileFilter();
        if (!path.endsWith(".jbrofuzz") || !jbfff.accept(file)) {
            JOptionPane.showMessageDialog(fc, "The file selected is not a valid .jbrofuzz file", " JBroFuzz - Open ", 2);
            return;
        }
        this.mWindow.getPanelFuzzing().clearAllFields();
        StringBuffer fileContents = new StringBuffer();
        BufferedReader in = null;
        try {
            int c;
            in = new BufferedReader(new FileReader(file));
            for (int counter = 0; (c = in.read()) > 0 && counter < Short.MAX_VALUE; ++counter) {
                if (!CharUtils.isAsciiPrintable((char)((char)c)) && (char)c != '\n') continue;
                fileContents.append((char)c);
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            Logger.log("FileNotFoundException", 3);
            IOUtils.closeQuietly((Reader)in);
        }
        catch (IOException e2) {
            Logger.log("IOException", 3);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Reader)in);
        }
        IOUtils.closeQuietly((Reader)in);
        String[] fileContentsArray = fileContents.toString().split("\n");
        int fileNoOfLines = fileContentsArray.length;
        if (fileNoOfLines < 12) {
            Logger.log("Invalid File: Contains less than 8 lines", 3);
            return;
        }
        if (!fileContentsArray[0].equals("[JBroFuzz]")) {
            Logger.log("Invalid File: Line 1 is not [JBroFuzz]", 3);
            return;
        }
        if (!fileContentsArray[2].equals("[Fuzzing]")) {
            Logger.log("Invalid File: Line 3 is not [Fuzzing]", 3);
            return;
        }
        if (!fileContentsArray[4].equals("[Comment]")) {
            Logger.log("Invalid File: Line 5 is not [Comment]", 3);
            return;
        }
        if (!fileContentsArray[6].equals("[URL]")) {
            Logger.log("Invalid File: Line 7 is not [URL]", 3);
            return;
        }
        if (!fileContentsArray[8].equals("[Request]")) {
            Logger.log("Invalid File: Line 9 is not [Request]", 3);
            return;
        }
        int fuzzersLine = 0;
        for (int fuzzerLineCounter = fileNoOfLines - 1; fuzzerLineCounter > 0; --fuzzerLineCounter) {
            if (!fileContentsArray[fuzzerLineCounter].equals("[Fuzzers]")) continue;
            if (fuzzersLine != 0) {
                Logger.log("Invalid File: Found 2 instances of [Fuzzers]", 3);
                return;
            }
            fuzzersLine = fuzzerLineCounter;
        }
        if (fuzzersLine == 0) {
            Logger.log("Invalid File: Cannot find a [Fuzzers] line", 3);
            return;
        }
        int transformsLine = 0;
        for (int transformsLineCounter = fileNoOfLines - 1; transformsLineCounter > 0; --transformsLineCounter) {
            if (!fileContentsArray[transformsLineCounter].equals("[Transforms]")) continue;
            if (transformsLine != 0) {
                Logger.log("Invalid File: Found 2 instances of [Transforms]", 3);
                return;
            }
            transformsLine = transformsLineCounter;
        }
        if (transformsLine == 0) {
            Logger.log("Invalid File: Cannot find a [Transforms] line", 3);
            return;
        }
        if (!fileContentsArray[fileNoOfLines - 1].equals("[End]")) {
            Logger.log("Invalid File: Last line is not [End]", 3);
            return;
        }
        String targetString = StringUtils.abbreviate((String)fileContentsArray[7], (int)Short.MAX_VALUE);
        this.mWindow.getPanelFuzzing().setTextURL(targetString);
        StringBuffer requestBuffer = new StringBuffer();
        for (int reqLineCount = 9; reqLineCount < fuzzersLine; ++reqLineCount) {
            requestBuffer.append(fileContentsArray[reqLineCount]);
            requestBuffer.append('\n');
        }
        this.mWindow.getPanelFuzzing().setTextRequest(requestBuffer.toString());
        if (fileNoOfLines - 1 - fuzzersLine - 1 > 1024) {
            Logger.log("Invalid File: More than 1024 Fuzzers Identified", 3);
            return;
        }
        for (int i = fuzzersLine + 1; i < transformsLine; ++i) {
            String[] payloadArray = fileContentsArray[i].split(",");
            if (payloadArray.length != 3) {
                Logger.log("Invalid File: Line " + (i + 1) + " does not contain 3 elements", 2);
                continue;
            }
            String fuzzerID = payloadArray[0];
            int start = 0;
            int end = 0;
            if (!Prototype.isValidFuzzerID(fuzzerID)) {
                Logger.log("Fuzzer Line Syntax Error: " + (i + 1) + " Invalid Fuzzer ID Format", 2);
                continue;
            }
            if (!this.mWindow.getJBroFuzz().getDatabase().containsPrototype(fuzzerID)) {
                Logger.log("Could not find Fuzzer with ID: " + fuzzerID, 2);
                continue;
            }
            try {
                start = Integer.parseInt(payloadArray[1]);
                end = Integer.parseInt(payloadArray[2]);
            }
            catch (NumberFormatException e) {
                Logger.log("Fuzzer Line Syntax Error: Number Format Exception", 2);
                continue;
            }
            if (start < 0 || end < 0) {
                Logger.log("Fuzzer Line Syntax Error: Negative Value", 2);
                continue;
            }
            if (start > requestBuffer.length() || end > requestBuffer.length()) {
                Logger.log("Fuzzer Line Syntax Error: Value Larger than Request", 2);
                continue;
            }
            Logger.log("Adding Fuzzer Line: \t" + (i + 1) + "\t" + fileContentsArray[i], 1);
            this.mWindow.getPanelFuzzing().getFuzzersPanel().addFuzzer(fuzzerID, start, end);
        }
        if (fileNoOfLines - 1 - transformsLine - 1 > 1024) {
            Logger.log("Invalid File: More than 1024 Transforms Identified", 3);
            return;
        }
        for (int j = transformsLine + 1; j < fileNoOfLines - 1; ++j) {
            String[] transformLineArray = fileContentsArray[j].split(",");
            int noOfElements = transformLineArray.length;
            if (noOfElements < 2 || noOfElements > 4) {
                Logger.log("Invalid File: Line " + (j + 1) + " does not contain 4 elements", 2);
                continue;
            }
            int fuzzerNumber = 0;
            try {
                fuzzerNumber = Integer.parseInt(transformLineArray[0]);
            }
            catch (NumberFormatException e) {
                Logger.log("Transform Line Syntax Error: Number Format Exception", 2);
                continue;
            }
            if (fuzzerNumber < 1) {
                Logger.log("Transform Line Syntax Error: Value Less Than One", 2);
                continue;
            }
            if (fuzzerNumber > transformsLine - fuzzersLine) {
                Logger.log("Transform Line Syntax Error: Transform Outside Fuzzer Range", 2);
                continue;
            }
            String encoder = StringUtils.abbreviate((String)transformLineArray[1], (int)Short.MAX_VALUE);
            if (!EncoderHashCore.isValidCode(encoder)) {
                Logger.log("Transform Line Syntax Error: Invalid Encode/Hash Code", 2);
                continue;
            }
            String prefix = "";
            if (transformLineArray.length >= 3) {
                try {
                    prefix = new String(Base64.decodeBase64((String)transformLineArray[2]), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    Logger.log("Transform Line Syntax Error: Cannot Decode Prefix", 2);
                    continue;
                }
                prefix = StringUtils.abbreviate((String)prefix, (int)Short.MAX_VALUE);
            }
            String suffix = "";
            if (transformLineArray.length >= 4) {
                try {
                    suffix = new String(Base64.decodeBase64((String)transformLineArray[3]), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    Logger.log("Transform Line Syntax Error: Cannot Decode Suffix", 2);
                    continue;
                }
                suffix = StringUtils.abbreviate((String)suffix, (int)Short.MAX_VALUE);
            }
            Logger.log("Adding Transform Line:\t" + (j + 1) + "\tOn Fuzzer Row:\t" + fuzzerNumber, 1);
            this.mWindow.getPanelFuzzing().getTransformsPanel().addTransform(fuzzerNumber, encoder, prefix, suffix);
        }
        this.mWindow.setOpenFileTo(file);
        String parentDir = file.getParent();
        if (parentDir != null) {
            JBroFuzz.PREFS.put(JBroFuzzPrefs.DIRS[2].getId(), parentDir);
        }
    }

    public JBroFuzzWindow getmWindow() {
        return this.mWindow;
    }
}

