/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.fuzz;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.owasp.jbrofuzz.JBroFuzz;
import org.owasp.jbrofuzz.fuzz.Connection;
import org.owasp.jbrofuzz.fuzz.ConnectionException;
import org.owasp.jbrofuzz.fuzz.SocketTimer;
import org.owasp.jbrofuzz.version.JBroFuzzPrefs;

class SocketConnection {
    private static final int RECV_BUF_SIZE = 262144;
    private static SSLSocketFactory mSSLSocketFactory;
    private final transient String message;
    private transient Socket mSocket;
    private transient String reply;
    private transient int port;
    private transient InputStream inStream;
    private transient OutputStream outStream;
    private int socketTimeout;

    protected SocketConnection(String protocol, String host, int port, String message) throws ConnectionException {
        byte[] recv = new byte[262144];
        this.message = message;
        this.socketTimeout = JBroFuzz.PREFS.getInt(JBroFuzzPrefs.FUZZING[0].getId(), 7);
        if (this.socketTimeout < 1 || this.socketTimeout > 51) {
            this.socketTimeout = 7;
        }
        try {
            int got;
            if (protocol.equalsIgnoreCase("https")) {
                if (mSSLSocketFactory == null) {
                    mSSLSocketFactory = Connection.getSocketFactory();
                }
                this.mSocket = mSSLSocketFactory.createSocket(host, port);
                this.mSocket.setSoTimeout(this.socketTimeout * 1000);
            } else {
                this.mSocket = new Socket();
                this.mSocket.connect(new InetSocketAddress(host, port), this.socketTimeout * 1000);
            }
            this.mSocket.setSendBufferSize(this.message.getBytes().length);
            this.mSocket.setReceiveBufferSize(262144);
            this.inStream = this.mSocket.getInputStream();
            this.outStream = this.mSocket.getOutputStream();
            this.outStream.write(this.message.getBytes());
            SocketTimer timer = new SocketTimer(this, this.socketTimeout * 1000);
            timer.start();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((got = this.inStream.read(recv)) > -1) {
                baos.write(recv, 0, got);
            }
            timer.reset();
            baos.close();
            this.inStream.close();
            this.outStream.close();
            this.mSocket.close();
            this.reply = new String(baos.toByteArray());
        }
        catch (MalformedURLException e1) {
            this.reply = "Malformed URL: " + e1.getMessage() + "\n";
            throw new ConnectionException(this.reply);
        }
        catch (IOException e3) {
            this.reply = "An IO Error occured: . \n\nThis could also be a Connection Timeout, \ntry increasing the value under Preferences -> Fuzzing\n";
            throw new ConnectionException(this.reply);
        }
        finally {
            IOUtils.closeQuietly((InputStream)this.inStream);
            IOUtils.closeQuietly((OutputStream)this.outStream);
        }
    }

    public String getMessage() {
        if (this.message.isEmpty()) {
            return "[JBROFUZZ REQUEST IS BLANK]";
        }
        return this.message;
    }

    public String getPort() {
        if (this.port == -1) {
            return "[JBROFUZZ PORT IS INVALID]";
        }
        return Integer.toString(this.port);
    }

    public String getReply() {
        if (this.reply.isEmpty()) {
            return "[JBROFUZZ REPLY IS EMPTY]";
        }
        return this.reply;
    }

    public String getStatus() {
        try {
            String out = this.reply.split(" ")[1].substring(0, 3);
            if (StringUtils.isNumeric((String)out)) {
                return out;
            }
            return "000";
        }
        catch (Exception exception1) {
            return "---";
        }
    }

    public void close() {
        IOUtils.closeQuietly((InputStream)this.inStream);
        IOUtils.closeQuietly((OutputStream)this.outStream);
    }
}

