/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.fuzz;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import org.owasp.jbrofuzz.JBroFuzz;
import org.owasp.jbrofuzz.encode.EncoderHashCore;
import org.owasp.jbrofuzz.version.JBroFuzzPrefs;

public class MessageCreator {
    private String message;
    private final String payload;
    private final String END_LINE;

    public MessageCreator(String url, String message, String payload, int start, int finish) {
        this.payload = payload;
        StringBuffer messageBuffer = new StringBuffer();
        messageBuffer.append(message.substring(0, start));
        messageBuffer.append(this.payload);
        messageBuffer.append(message.substring(finish));
        boolean endLineChar = JBroFuzz.PREFS.getBoolean(JBroFuzzPrefs.FUZZING[1].getId(), true);
        this.END_LINE = endLineChar ? "\r\n" : "\n";
        this.message = MessageCreator.stringReplace("\n", messageBuffer.toString(), this.END_LINE);
        this.message = this.doAppendCRLF(this.message);
        boolean addConnectionClosedHeader = JBroFuzz.PREFS.getBoolean(JBroFuzzPrefs.FUZZING[5].getId(), true);
        if (addConnectionClosedHeader) {
            this.message = this.doConnectionCloseHeader(this.message);
        }
        this.message = this.doContentLengthReWrite(this.message);
        boolean addAuthHeader = JBroFuzz.PREFS.getBoolean(JBroFuzzPrefs.FUZZING[4].getId(), true);
        if (addAuthHeader) {
            this.message = this.doBasicAuthHeader(url, this.message);
        }
    }

    private String doConnectionCloseHeader(String message) {
        String TOBEFOUND = "Connection:";
        int ctl = message.toLowerCase().indexOf("\n" + "Connection:".toLowerCase());
        if (ctl != -1) {
            return message;
        }
        String ENDCREDITS = this.END_LINE + this.END_LINE;
        int eoh = message.indexOf(ENDCREDITS);
        if (eoh == -1) {
            return message + "Connection:" + " close" + ENDCREDITS;
        }
        return MessageCreator.stringReplace(ENDCREDITS, message, this.END_LINE + "Connection:" + " close" + ENDCREDITS);
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessageForDisplayPurposes() {
        if ("\n".equals(this.END_LINE)) {
            return MessageCreator.stringReplace("\n", this.message, "\\n\n");
        }
        return MessageCreator.stringReplace("\r\n", this.message, "\\r\\n\n");
    }

    public String getPostDataForDisplayPurposes() {
        String postDataString;
        try {
            postDataString = this.message.split("\r\n\r\n")[1];
        }
        catch (Exception e1) {
            postDataString = this.message;
        }
        if ("\n".equals(this.END_LINE)) {
            return MessageCreator.stringReplace("\n", postDataString, "\\n\n");
        }
        return MessageCreator.stringReplace("\r\n", postDataString, "\\r\\n\n");
    }

    public String getPayload() {
        return this.payload;
    }

    private String doContentLengthReWrite(String message) {
        if (!message.startsWith("POST")) {
            return message;
        }
        String ENDCREDITS = this.END_LINE + this.END_LINE;
        int eoh = message.indexOf(ENDCREDITS);
        if (eoh == -1) {
            return message;
        }
        String TOBEFOUND = "Content-Length:";
        int ctl = this.message.indexOf("Content-Length:");
        if (ctl == -1) {
            return message;
        }
        int contentLength = 0;
        String postValue = message.substring(eoh + ENDCREDITS.length());
        int neol = this.message.indexOf(this.END_LINE, ctl);
        if (neol == -1) {
            return message;
        }
        String contLengthString = message.substring(ctl + "Content-Length:".length(), neol);
        try {
            contentLength = Integer.parseInt(contLengthString);
        }
        catch (NumberFormatException e) {
            contentLength = 0;
        }
        if (contentLength == postValue.getBytes().length) {
            return message;
        }
        StringBuffer newMsgBuffer = new StringBuffer();
        newMsgBuffer.append(message.substring(0, ctl + "Content-Length:".length()));
        try {
            newMsgBuffer.append(' ');
            newMsgBuffer.append(postValue.getBytes("ISO-8859-1").length);
        }
        catch (UnsupportedEncodingException e) {
            newMsgBuffer.append(' ');
            newMsgBuffer.append(postValue.getBytes().length);
        }
        String remainingHeader = this.message.substring(neol, eoh + ENDCREDITS.length());
        if (remainingHeader.startsWith(this.END_LINE)) {
            newMsgBuffer.append(this.END_LINE);
            newMsgBuffer.append(this.END_LINE);
        } else {
            newMsgBuffer.append(remainingHeader);
        }
        newMsgBuffer.append(postValue);
        return newMsgBuffer.toString();
    }

    private String doAppendCRLF(String message) {
        String ENDCREDITS = this.END_LINE + this.END_LINE;
        if (message.startsWith("GET") || message.startsWith("HEAD") || message.startsWith("OPTIONS")) {
            if (!this.message.endsWith(ENDCREDITS)) {
                return message + ENDCREDITS;
            }
            return message;
        }
        return message;
    }

    private String doBasicAuthHeader(String url, String message) {
        URL currentURL;
        try {
            currentURL = new URL(url);
        }
        catch (MalformedURLException e) {
            return message;
        }
        String userInfo = currentURL.getUserInfo();
        if (userInfo == null) {
            return message;
        }
        String encoding = EncoderHashCore.encode(userInfo, "Base64");
        String authHeader = "Proxy-Authorization: Basic " + encoding + "\n";
        String ENDCREDITS = this.END_LINE + this.END_LINE;
        int eoh = message.indexOf(ENDCREDITS);
        if (eoh == -1) {
            return message + authHeader + ENDCREDITS;
        }
        return MessageCreator.stringReplace(ENDCREDITS, message, this.END_LINE + authHeader + ENDCREDITS);
    }

    private static String stringReplace(String toFind, String original, String substitute) {
        if (toFind.equals(substitute)) {
            return original;
        }
        int found = 0;
        int start = 0;
        String returnString = original;
        while (found != -1) {
            found = returnString.indexOf(toFind, start);
            if (found != -1) {
                returnString = returnString.substring(0, found).concat(substitute).concat(returnString.substring(found + toFind.length()));
            }
            start = found + substitute.length();
        }
        return returnString;
    }
}

