/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.core.net;

import java.util.Iterator;
import java.util.Locale;
import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.owasp.jbrofuzz.core.NoSuchFuzzerException;

public class MACAddrFuzzer
implements Iterator<String> {
    private static final String HEX_DIGITS = "0123456789ABCDEF";
    private static final String ERROR_MSG = "Not a valid MAC Address";
    private long currentValue;
    private long maxValue;
    private char[] hexCharArray = new char[16];
    private Separator separator;

    public MACAddrFuzzer() {
        this(Separator.COLON);
    }

    public MACAddrFuzzer(Separator separator) {
        this.separator = separator;
        this.currentValue = 0L;
        this.maxValue = 0x1000000000000L;
        this.hexCharArray = HEX_DIGITS.toCharArray();
    }

    public MACAddrFuzzer(String macStart) throws NoSuchFuzzerException {
        this(macStart, "FF:FF:FF:FF:FF:FF");
    }

    public MACAddrFuzzer(String macStart, Separator separator) throws NoSuchFuzzerException {
        this(macStart, "FF:FF:FF:FF:FF:FF", separator);
    }

    public MACAddrFuzzer(String macStart, String macEnd) throws NoSuchFuzzerException {
        char charSeparator1 = MACAddrFuzzer.getFirstSeparator(macStart);
        char charSeparator2 = MACAddrFuzzer.getFirstSeparator(macEnd);
        this.separator = MACAddrFuzzer.getSeparatorEnum(charSeparator1);
        if (!MACAddrFuzzer.isValidMACAddress(macStart, charSeparator1)) {
            throw new NoSuchFuzzerException(ERROR_MSG);
        }
        if (!MACAddrFuzzer.isValidMACAddress(macEnd, charSeparator2)) {
            throw new NoSuchFuzzerException(ERROR_MSG);
        }
        this.currentValue = MACAddrFuzzer.parseMAC(macStart, charSeparator1);
        this.maxValue = MACAddrFuzzer.parseMAC(macEnd, charSeparator2);
        this.hexCharArray = Character.isLowerCase(macStart.charAt(0)) ? HEX_DIGITS.toLowerCase(Locale.ENGLISH).toCharArray() : HEX_DIGITS.toCharArray();
    }

    public MACAddrFuzzer(String macStart, String macEnd, Separator separator) throws NoSuchFuzzerException {
        char charSeparator1 = MACAddrFuzzer.getFirstSeparator(macStart);
        char charSeparator2 = MACAddrFuzzer.getFirstSeparator(macEnd);
        this.separator = separator;
        if (!MACAddrFuzzer.isValidMACAddress(macStart, charSeparator1)) {
            throw new NoSuchFuzzerException(ERROR_MSG);
        }
        if (!MACAddrFuzzer.isValidMACAddress(macEnd, charSeparator2)) {
            throw new NoSuchFuzzerException(ERROR_MSG);
        }
        this.currentValue = MACAddrFuzzer.parseMAC(macStart, charSeparator1);
        this.maxValue = MACAddrFuzzer.parseMAC(macEnd, charSeparator2);
        this.hexCharArray = Character.isLowerCase(macStart.charAt(0)) ? HEX_DIGITS.toLowerCase(Locale.ENGLISH).toCharArray() : HEX_DIGITS.toCharArray();
    }

    public long getCurrentValue() {
        return this.currentValue;
    }

    public void resetCurrentValue() {
        this.currentValue = 0L;
    }

    public String getId() {
        return "050-MAC-ADD";
    }

    public long getMaximumValue() {
        return this.maxValue;
    }

    public String getName() {
        return "MAC Address Fuzzer";
    }

    @Override
    public boolean hasNext() {
        return this.currentValue <= this.maxValue;
    }

    @Override
    public String next() {
        char delim;
        long val;
        StringBuffer output = new StringBuffer(17);
        Stack<Integer> stack = new Stack<Integer>();
        for (val = this.currentValue; val >= 16L; val /= 16L) {
            stack.push((int)val % 16);
        }
        output.append(StringUtils.leftPad((String)Character.toString(this.hexCharArray[(int)val]), (int)(12 - stack.size()), (String)"0"));
        while (!stack.isEmpty()) {
            output.append(Character.toString(this.hexCharArray[(Integer)stack.pop()]));
        }
        ++this.currentValue;
        if (this.separator == Separator.NONE) {
            return output.toString();
        }
        switch (this.separator) {
            case HYPHEN: {
                delim = '-';
                break;
            }
            case COLON: {
                delim = ':';
                break;
            }
            case SPACE: {
                delim = ' ';
                break;
            }
            case UNDERSCORE: {
                delim = '_';
                break;
            }
            default: {
                delim = ':';
            }
        }
        for (int index = 2; index < 17; index += 3) {
            output.insert(index, delim);
        }
        return output.toString();
    }

    @Override
    public void remove() {
        --this.currentValue;
    }

    private static Separator getSeparatorEnum(char separator) {
        switch (separator) {
            case '-': {
                return Separator.HYPHEN;
            }
            case ':': {
                return Separator.COLON;
            }
            case '_': {
                return Separator.UNDERSCORE;
            }
            case ' ': {
                return Separator.SPACE;
            }
        }
        return Separator.COLON;
    }

    private static char getFirstSeparator(String mac) {
        try {
            return mac.charAt(2);
        }
        catch (StringIndexOutOfBoundsException e) {
            return '0';
        }
    }

    public static boolean isValidMACAddress(String mac) {
        return MACAddrFuzzer.isValidMACAddress(mac, ':');
    }

    public static boolean isValidMACAddress(String mac, char separator) {
        int macAddrLength = mac.length();
        if (macAddrLength != 17) {
            return false;
        }
        for (int index = 0; index < macAddrLength; ++index) {
            char charAt = mac.charAt(index);
            if (!((index + 1) % 3 == 0 ? charAt != separator : !MACAddrFuzzer.isHexDigit(charAt))) continue;
            return false;
        }
        return true;
    }

    public static boolean isHexDigit(char currentChar) {
        for (char current : HEX_DIGITS.toCharArray()) {
            if (current != currentChar) continue;
            return true;
        }
        for (char current : HEX_DIGITS.toLowerCase(Locale.ENGLISH).toCharArray()) {
            if (current != currentChar) continue;
            return true;
        }
        return false;
    }

    public static long parseMAC(String mac) {
        return MACAddrFuzzer.parseMAC(mac, ':');
    }

    public static long parseMAC(String mac, char delim) {
        if (!MACAddrFuzzer.isValidMACAddress(mac, delim)) {
            return -1L;
        }
        StringTokenizer sTokeniser = new StringTokenizer(mac, Character.toString(delim));
        long value = 0L;
        for (int octet = 6; octet > 0; --octet) {
            value = (long)((double)value + (double)Integer.parseInt(sTokeniser.nextToken(), 16) * Math.pow(256.0, octet - 1));
        }
        return value;
    }

    public static enum Separator {
        HYPHEN,
        COLON,
        SPACE,
        UNDERSCORE,
        NONE;

    }
}

