/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.core;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class Prototype {
    private final transient List<String> categories;
    private final transient List<String> payloads;
    private final transient String name;
    private final transient String uniqId;
    private final transient char type;
    private transient String comment;

    private static String calculatePayload(String param) {
        int times;
        String beginning;
        try {
            beginning = param.substring(0, 5);
        }
        catch (IndexOutOfBoundsException e1) {
            return param;
        }
        if (!beginning.startsWith("f(x)=")) {
            return param;
        }
        String parameter = param.substring(5);
        String[] paramArray = parameter.split(" x ");
        if (paramArray.length != 2) {
            return parameter;
        }
        String input = paramArray[0];
        try {
            times = Integer.parseInt(paramArray[1]);
        }
        catch (NumberFormatException e) {
            times = 1;
        }
        if (times <= 0) {
            return parameter;
        }
        int len = input.length() * times;
        if (len > 0x2000000) {
            return parameter;
        }
        StringBuffer newBuffer = new StringBuffer(len);
        for (int i = 0; i < times; ++i) {
            newBuffer.append(input);
        }
        return newBuffer.toString();
    }

    public static boolean isValidFuzzerType(char inputType) {
        if (inputType == 'P') {
            return true;
        }
        if (inputType == 'R') {
            return true;
        }
        if (inputType == 'Z') {
            return true;
        }
        if (inputType == 'D') {
            return true;
        }
        if (inputType == 'X') {
            return true;
        }
        if (inputType == 'P') {
            return true;
        }
        return inputType == 'H';
    }

    public static boolean isValidFuzzerID(String fuzzerID) {
        int fuzzerLength = fuzzerID.length();
        if (fuzzerLength != 11) {
            return false;
        }
        if (!Character.isDigit(fuzzerID.charAt(0))) {
            return false;
        }
        if (!Character.isDigit(fuzzerID.charAt(1))) {
            return false;
        }
        if (!Character.isDigit(fuzzerID.charAt(2))) {
            return false;
        }
        if (fuzzerID.charAt(3) != '-') {
            return false;
        }
        if (!Character.isLetterOrDigit(fuzzerID.charAt(4))) {
            return false;
        }
        if (!Character.isLetterOrDigit(fuzzerID.charAt(5))) {
            return false;
        }
        if (!Character.isLetterOrDigit(fuzzerID.charAt(6))) {
            return false;
        }
        if (fuzzerID.charAt(7) != '-') {
            return false;
        }
        if (!Character.isLetterOrDigit(fuzzerID.charAt(8))) {
            return false;
        }
        if (!Character.isLetterOrDigit(fuzzerID.charAt(9))) {
            return false;
        }
        return Character.isLetterOrDigit(fuzzerID.charAt(10));
    }

    public Prototype(char type, String uniqId, String name) {
        this(type, uniqId, name, new ArrayList<String>(), new ArrayList<String>());
    }

    public Prototype(char type, String uniqId, String name, List<String> categories, List<String> payloads) {
        this.type = type;
        this.uniqId = uniqId;
        this.name = StringUtils.trim((String)name);
        this.categories = categories;
        this.payloads = payloads;
    }

    public void addCategory(String category) {
        this.categories.add(category);
    }

    public void addPayload(String payload) {
        this.payloads.add(Prototype.calculatePayload(payload));
    }

    public List<String> getCategories() {
        return this.categories;
    }

    protected String getId() {
        return this.uniqId;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getPayloads() {
        return this.payloads;
    }

    public String getType() {
        if (this.type == 'P') {
            return "Replacive";
        }
        if (this.type == 'R') {
            return "Recursive";
        }
        if (this.type == 'Z') {
            return "Zero";
        }
        if (this.type == 'D') {
            return "Double";
        }
        if (this.type == 'X') {
            return "Cross Product";
        }
        return "";
    }

    protected boolean isAMemberOfCategory(String category) {
        String[] categoriesArray = new String[this.categories.size()];
        this.categories.toArray(categoriesArray);
        for (String s : categoriesArray) {
            if (!s.equalsIgnoreCase(category)) continue;
            return true;
        }
        return false;
    }

    public boolean isRecursive() {
        return this.type == 'R';
    }

    public boolean isZero() {
        return this.type == 'Z';
    }

    public int size() {
        return this.payloads.size();
    }

    public int getNoOfCategories() {
        return this.categories.size();
    }

    public void addComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }
}

