/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.core;

import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.owasp.jbrofuzz.core.NoSuchFuzzerException;
import org.owasp.jbrofuzz.core.Prototype;

public class Fuzzer
implements Iterator<String> {
    private final transient int len;
    private final transient Prototype prototype;
    private transient List<String> payloads;
    private transient long cValue;
    private transient long maxValue;

    protected Fuzzer(Prototype prototype, int len) throws NoSuchFuzzerException {
        this.prototype = prototype;
        if (prototype == null) {
            this.maxValue = 0L;
        } else {
            this.payloads = this.prototype.getPayloads();
            this.maxValue = this.prototype.isRecursive() ? Fuzzer.pow(this.payloads.size(), len) : (long)this.payloads.size();
        }
        this.cValue = 0L;
        this.len = len;
    }

    public long getCurrentValue() {
        return this.cValue;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public void resetCurrentValue() {
        this.cValue = 0L;
    }

    public String getId() {
        return this.prototype.getId();
    }

    public long getMaximumValue() {
        return this.maxValue;
    }

    public String getName() {
        return this.prototype.getName();
    }

    @Override
    public boolean hasNext() {
        return this.cValue < this.maxValue;
    }

    @Override
    public String next() {
        StringBuffer output = new StringBuffer();
        if (this.maxValue == (long)this.payloads.size()) {
            ++this.cValue;
            output.append(this.payloads.get((int)this.cValue - 1));
        } else {
            long val;
            Stack<Integer> stack = new Stack<Integer>();
            for (val = this.cValue; val >= (long)this.payloads.size(); val /= (long)this.payloads.size()) {
                stack.push((int)val % this.payloads.size());
            }
            output.append(StringUtils.leftPad((String)this.payloads.get((int)val), (int)(this.len - stack.size()), (String)this.payloads.get(0)));
            while (!stack.isEmpty()) {
                output.append(this.payloads.get((Integer)stack.pop()));
            }
            ++this.cValue;
        }
        return output.toString();
    }

    @Override
    public void remove() {
        --this.cValue;
    }

    private static long pow(int alpha, int beta) {
        long gamma = (long)beta & 0xFFFFFFFFL;
        long result = 1L;
        long powerN = alpha;
        while (gamma != 0L) {
            if ((gamma & 1L) != 0L) {
                result *= powerN;
            }
            gamma >>>= 1;
            powerN *= powerN;
        }
        return result;
    }
}

