/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.contrib.spring.encryptedproperty;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.owasp.esapi.EncryptedProperties;
import org.owasp.esapi.reference.crypto.ReferenceEncryptedProperties;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.util.CollectionUtils;

public class EncryptedPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    private EncryptedProperties[] localProperties;
    private boolean localOverride = false;

    public void setLocalOverride(boolean localOverride) {
        this.localOverride = localOverride;
        super.setLocalOverride(localOverride);
    }

    public void setProperties(Properties properties) {
        if (properties instanceof EncryptedProperties) {
            super.setPropertiesArray(new Properties[]{properties});
        } else {
            ReferenceEncryptedProperties eProps = new ReferenceEncryptedProperties(properties);
            super.setPropertiesArray(new Properties[]{(Properties)eProps});
        }
    }

    public void setPropertiesArray(Properties[] propertiesArray) {
        ArrayList<Properties> propsList = new ArrayList<Properties>(propertiesArray.length);
        for (Properties properties : propertiesArray) {
            if (properties instanceof EncryptedProperties) {
                propsList.add(properties);
                continue;
            }
            ReferenceEncryptedProperties eProps = new ReferenceEncryptedProperties(properties);
            propsList.add((Properties)eProps);
        }
        super.setPropertiesArray(propsList.toArray(new Properties[propsList.size()]));
    }

    protected Properties mergeProperties() throws IOException {
        ReferenceEncryptedProperties result = new ReferenceEncryptedProperties();
        if (this.localOverride) {
            this.loadProperties((Properties)result);
        }
        if (this.localProperties != null) {
            for (int i = 0; i < this.localProperties.length; ++i) {
                CollectionUtils.mergePropertiesIntoMap((Properties)((Properties)this.localProperties[i]), (Map)result);
            }
        }
        if (!this.localOverride) {
            this.loadProperties((Properties)result);
        }
        return result;
    }

    protected void loadProperties(Properties props) throws IOException {
        if (!(props instanceof EncryptedProperties)) {
            props = new ReferenceEncryptedProperties(props);
        }
        super.loadProperties(props);
    }
}

