/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils.processing;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.owasp.dependencycheck.utils.processing.Processor;

public class ProcessReader
implements AutoCloseable {
    private final Process process;
    private Gobbler errorGobbler = null;
    private Gobbler inputGobbler = null;
    private Processor<InputStream> processor = null;
    private final List<Thread> threads = new ArrayList<Thread>();

    public ProcessReader(Process process) {
        this(process, null);
    }

    public ProcessReader(Process process, Processor<InputStream> processor) {
        this.process = process;
        this.processor = processor;
    }

    public String getError() {
        return this.errorGobbler.getText();
    }

    public String getOutput() {
        return this.inputGobbler != null ? this.inputGobbler.getText() : null;
    }

    public void readAll() throws InterruptedException, IOException {
        this.start();
        this.close();
    }

    private void start() {
        this.errorGobbler = new Gobbler(this.process.getErrorStream());
        this.startProcessor(this.errorGobbler);
        if (this.processor == null) {
            this.inputGobbler = new Gobbler(this.process.getInputStream());
            this.startProcessor(this.inputGobbler);
        } else {
            this.processor.setInput(this.process.getInputStream());
            this.startProcessor(this.processor);
        }
    }

    private void startProcessor(Processor p) {
        if (p != null) {
            Thread t = new Thread(p);
            this.threads.add(t);
            t.start();
        }
    }

    @Override
    public void close() throws InterruptedException, IOException {
        if (this.process.isAlive()) {
            this.process.waitFor();
        }
        if (this.threads.size() > 0) {
            for (Thread thread : this.threads) {
                thread.join();
            }
            this.threads.clear();
        }
        this.errorGobbler.close();
        if (this.inputGobbler != null) {
            this.inputGobbler.close();
        }
    }

    static class Gobbler
    extends Processor<InputStream> {
        private IOException exception;
        private String text;

        Gobbler(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        public void run() {
            try {
                InputStream inputStream = (InputStream)this.getInput();
                if (inputStream.available() > 0) {
                    this.text = IOUtils.toString((InputStream)inputStream, (String)StandardCharsets.UTF_8.name());
                }
            }
            catch (IOException ex) {
                this.exception = ex;
            }
        }

        public String getText() {
            return this.text;
        }

        @Override
        public void close() throws IOException {
            if (this.exception != null) {
                throw this.exception;
            }
        }
    }
}

