/*
 * Decompiled with CFR 0.152.
 */
package org.xlcloud.openstack.client;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.xlcloud.logging.LoggingUtils;
import org.xlcloud.openstack.api.IdentityManagementClient;
import org.xlcloud.openstack.api.identity.IdentityAdministrationEndpoint;
import org.xlcloud.openstack.api.identity.UserResource;
import org.xlcloud.openstack.api.identity.UsersResource;
import org.xlcloud.openstack.client.AuthFilter;
import org.xlcloud.openstack.client.ExceptionHandlingFilter;
import org.xlcloud.openstack.client.KeystoneRestClientProducer;
import org.xlcloud.openstack.client.RefreshAuthenticationHandler;
import org.xlcloud.openstack.model.exceptions.OpenStackAuthenticationException;
import org.xlcloud.openstack.model.exceptions.OpenStackNotFoundException;
import org.xlcloud.openstack.model.identity.Access;
import org.xlcloud.openstack.model.identity.Role;
import org.xlcloud.openstack.model.identity.RoleList;
import org.xlcloud.openstack.model.identity.Tenant;
import org.xlcloud.openstack.model.identity.TenantList;
import org.xlcloud.openstack.model.identity.User;
import org.xlcloud.openstack.model.identity.UserForCreate;
import org.xlcloud.openstack.model.identity.UserList;
import org.xlcloud.openstack.model.identity.keystone.KeystoneAccess;
import org.xlcloud.openstack.model.identity.keystone.KeystoneAuthentication;
import org.xlcloud.openstack.rest.PerformanceMonitorFilter;
import org.xlcloud.rest.client.config.ClientLoggingFilter;

public class OpenStackKeystoneClient
implements IdentityManagementClient {
    private static final Logger LOG = Logger.getLogger(OpenStackKeystoneClient.class);
    private final String resourceUri;
    private final Client client = KeystoneRestClientProducer.INSTANCE.produceClient();
    private String tokenId;

    private OpenStackKeystoneClient(String endpoint) {
        this.resourceUri = endpoint;
        LOG.debug((Object)("Using Jersey client " + this.client.hashCode()));
    }

    public static IdentityManagementClient getKeystoneClientInstance(String username, String password, String tenantName, String endpointUri) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating new OpenStackClient for user " + username + " on tenant " + tenantName + ". Endpoint URI: " + endpointUri));
        }
        OpenStackKeystoneClient osClient = new OpenStackKeystoneClient(endpointUri);
        osClient.setFilters();
        RefreshAuthenticationHandler handler = new RefreshAuthenticationHandler(osClient, username, password, tenantName);
        IdentityManagementClient imClient = (IdentityManagementClient)Proxy.newProxyInstance(OpenStackKeystoneClient.class.getClassLoader(), new Class[]{IdentityManagementClient.class}, (InvocationHandler)handler);
        return imClient;
    }

    public static IdentityManagementClient getKeystoneClientInstance(String token, String endpointUri) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating new OpenStackClient with token: " + LoggingUtils.maskPartially((String)token) + ". Endpoint URI: " + endpointUri));
        }
        OpenStackKeystoneClient osClient = new OpenStackKeystoneClient(endpointUri);
        osClient.setToken(token);
        return osClient;
    }

    @Override
    public void reauthenticate(String username, String password, String tenantName) {
        if (this.isTokenValid(this.tokenId)) {
            LOG.warn((Object)"Current token is valid, but we'll reauthenticate the user anyway.");
        }
        KeystoneAuthentication authentication = KeystoneAuthentication.withPasswordCredentials(username, password);
        if (StringUtils.isNotBlank((String)tenantName)) {
            authentication.setTenantName(tenantName);
        }
        Access access = (Access)((WebResource.Builder)this.client.resource(this.resourceUri + "/tokens").type("application/json").accept(new String[]{"application/json"})).post(KeystoneAccess.class, (Object)authentication);
        this.tokenId = access.getToken().getId();
        this.setFilters();
    }

    void setToken(String id) {
        this.tokenId = id;
        this.setFilters();
    }

    @Override
    public String getToken() {
        return this.tokenId;
    }

    private void setFilters() {
        this.client.removeAllFilters();
        if (this.tokenId != null) {
            this.client.addFilter((ClientFilter)new AuthFilter(this.tokenId));
        }
        this.client.addFilter((ClientFilter)new ClientLoggingFilter());
        this.client.addFilter((ClientFilter)new ExceptionHandlingFilter());
        this.client.addFilter((ClientFilter)new PerformanceMonitorFilter());
    }

    private IdentityAdministrationEndpoint getIdentityAdministationEndpoint() {
        return new IdentityAdministrationEndpoint(this.client, this.resourceUri);
    }

    @Override
    public boolean isTokenValid(String token) {
        if (StringUtils.isBlank((String)token)) {
            return false;
        }
        try {
            String digest = DigestUtils.md5Hex((String)token);
            LOG.debug((Object)("Transformed token [" + LoggingUtils.maskPartially((String)token) + "] to digest [" + digest + "]"));
            this.getIdentityAdministationEndpoint().tokens().token(digest).get();
        }
        catch (OpenStackAuthenticationException | OpenStackNotFoundException ex) {
            return false;
        }
        return true;
    }

    @Override
    public UserList getUserResources() {
        return this.getIdentityAdministationEndpoint().users().get();
    }

    @Override
    public User getUserById(String id) {
        return this.getIdentityAdministationEndpoint().users().user(id).get();
    }

    @Override
    public User getUserByName(String name) throws OpenStackNotFoundException {
        return this.getIdentityAdministationEndpoint().users().getUserByName(name);
    }

    @Override
    public void deleteUserById(String id) {
        this.getIdentityAdministationEndpoint().users().user(id).delete();
    }

    @Override
    public User createUser(UserForCreate user) {
        IdentityAdministrationEndpoint identityAdministationEndpoint = this.getIdentityAdministationEndpoint();
        UsersResource users = identityAdministationEndpoint.users();
        return users.post(user);
    }

    @Override
    public User updateUser(UserForCreate user) {
        IdentityAdministrationEndpoint identityAdministationEndpoint = this.getIdentityAdministationEndpoint();
        UserResource userRespource = identityAdministationEndpoint.users().user(user.getId());
        return userRespource.put(user);
    }

    @Override
    public Tenant createTentant(Tenant tenant) {
        return this.getIdentityAdministationEndpoint().tenants().post(tenant);
    }

    @Override
    public Role createRole(Role role) {
        return this.getIdentityAdministationEndpoint().roles().post(role);
    }

    @Override
    public TenantList getTenantResources() {
        return this.getIdentityAdministationEndpoint().tenants().get();
    }

    @Override
    public Role assignRole(String userId, String roleId, String tenantId) {
        return this.getIdentityAdministationEndpoint().tenants().tenant(tenantId).users().user(userId).roles().role(roleId).put();
    }

    @Override
    public void removeRole(String userId, String roleId, String tenantId) {
        this.getIdentityAdministationEndpoint().tenants().tenant(tenantId).users().user(userId).roles().role(roleId).delete();
    }

    @Override
    public RoleList getRoleResources() {
        return this.getIdentityAdministationEndpoint().roles().get();
    }

    @Override
    public Tenant getTenantByName(String name) throws OpenStackNotFoundException {
        return this.getIdentityAdministationEndpoint().tenants().getTenantByName(name);
    }

    @Override
    public Role getRoleByName(String name) throws OpenStackNotFoundException {
        RoleList roleList = this.getRoleResources();
        if (roleList != null) {
            List<Role> roles = roleList.getList();
            for (Role role : roles) {
                if (!name.equals(role.getName())) continue;
                return role;
            }
        }
        throw new OpenStackNotFoundException("Could not find role: " + name);
    }

    @Override
    public Tenant getTenantById(String id) {
        return this.getIdentityAdministationEndpoint().tenants().tenant(id).get();
    }

    @Override
    public void removeTenant(String id) {
        this.getIdentityAdministationEndpoint().tenants().tenant(id).delete();
    }

    @Override
    public RoleList getUserRolesInTenant(String userId, String tenantId) {
        return this.getIdentityAdministationEndpoint().tenants().tenant(tenantId).users().user(userId).roles().get();
    }

    @Override
    public void removeAllUserRolesInTenant(String userId, String tenantId) {
        RoleList roleList = this.getUserRolesInTenant(userId, tenantId);
        if (roleList == null) {
            return;
        }
        for (Role role : roleList.getList()) {
            this.removeRole(userId, role.getId(), tenantId);
        }
    }
}

